% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/v1-glScatter.R
\name{glScatter.default}
\alias{glScatter.default}
\title{Glimma Scatter Plot}
\usage{
\method{glScatter}{default}(
  x,
  xval = "x",
  yval = "y",
  idval = NULL,
  point.size = 2,
  x.jitter = 0,
  y.jitter = 0,
  ndigits = NULL,
  signif = 6,
  log = "",
  xgrid = FALSE,
  ygrid = FALSE,
  xstep = FALSE,
  ystep = FALSE,
  xlab = xval,
  ylab = yval,
  main = NULL,
  height = 400,
  width = 500,
  colval = NULL,
  annot = c(xval, yval),
  annot.lab = NULL,
  flag = NULL,
  info = NULL,
  hide = FALSE,
  disable = NULL,
  ...
)
}
\arguments{
\item{x}{the data.frame containing data to plot.}

\item{xval}{the column name for the x-axis values.}

\item{yval}{the column name for the y-axis values.}

\item{idval}{the column name for unique identifiers.}

\item{point.size}{the size of the data points.}

\item{x.jitter}{the amount of jittering to add to values along the x axis.}

\item{y.jitter}{the amount of jittering to add to values along the y axis.}

\item{ndigits}{the number of digits after the decimal to round to in the tooltip (overrides signif).}

\item{signif}{the number of significant figures to display in the tooltip.}

\item{log}{a character string which contains "x" if the x axis is to be logarithmic, "y" if the y axis is to be logarithmic and "xy" or "yx" if both axes are to be logarithmic.}

\item{xgrid}{TRUE if grid lines should be placed along x axis.}

\item{ygrid}{TRUE if grid lines should be placed y axis.}

\item{xstep}{the interval at which to set grid lines along the x axis.}

\item{ystep}{the interval at which to set grid lines along the y axis.}

\item{xlab}{the label on the x-axis.}

\item{ylab}{the label on the y-axis.}

\item{main}{the title for the plot.}

\item{height}{the height of the plot (in pixels).}

\item{width}{the width of the plot (in pixels).}

\item{colval}{the colours for each data point.}

\item{annot}{the columns to display in the tooltip.}

\item{annot.lab}{alternative labels for the values displayed in the tooltip.}

\item{flag}{the special flag to indicate special plot.}

\item{info}{additional information for plotting.}

\item{hide}{TRUE to hide the plot when page starts.}

\item{disable}{the events to disable, options are "click", "hover", "zoom".}

\item{...}{additional arguments.}
}
\value{
A chart object containing the information to create an interactive scatter plot.
}
\description{
Default method for creating an interactive scatter plot
}
\author{
Shian Su
}
\keyword{internal}
