% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gtoxCalcVmad.R
\name{gtoxCalcVmad}
\alias{gtoxCalcVmad}
\title{Calculate and update the assay endpoint cutoff values}
\usage{
gtoxCalcVmad(inputs, aeid = NULL, notes = NULL)
}
\arguments{
\item{inputs}{integer, the aeid(s) used to calculate the cutoff values}

\item{aeid}{integer, the aeid(s) to be updated in the database}

\item{notes}{character of length 1, (optional) comments/justification}
}
\value{
None
}
\description{
\code{gtoxCalcVmad} takes the input aeid values and uses them to calculate
the assay endpoint cutoff based on the median absolute deviation of vehicle
values across the given assay endpoints.
}
\details{
If 'aeid' is NULL, the value will be returned with no changes made to the
database.

Cutoffs are caluted as the median absolute value of the vehicle values
across the assay endpoints given by 'inputs'.
}
\examples{
## Store the current config settings, so they can be reloaded at the end 
## of the examples
conf_store <- gtoxConfList()
gtoxConfDefault()

## Prepare for analysis before QC + process data
gtoxCalcVmad(inputs = 10L)

## Reset configuration
options(conf_store)

}
