% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NanoStringGeoMxSet-normalize.R
\name{checkQCFlags}
\alias{checkQCFlags}
\title{Check QC Flags in the GeoMxSet and removes the probe or sample from the object}
\usage{
checkQCFlags(object, ...)
}
\arguments{
\item{object}{name of the NanoStringGeoMxSet object to check the QC Flags}

\item{...}{for other arguments}
}
\value{
a NanoStringGeoMxSet object probes and samples failing QC removed
}
\description{
Check QC Flags in the GeoMxSet and removes the probe or sample from the object
}
\examples{
datadir <- system.file("extdata", "DSP_NGS_Example_Data",
  package = "GeomxTools"
)
demoData <- readRDS(file.path(datadir, "/demoData.rds"))
QCobject <- checkQCFlags(demoData)
}
