% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PoisBG.R
\docType{methods}
\name{QuanRange}
\alias{QuanRange}
\alias{QuanRange,NanoStringGeoMxSet-method}
\alias{QuanRange,matrix-method}
\title{Compute Quantile Range}
\usage{
QuanRange(object, ...)

\S4method{QuanRange}{NanoStringGeoMxSet}(object, split = FALSE, probs, removeoutlier = FALSE, ...)

\S4method{QuanRange}{matrix}(object, probenum, BGmod, probs, removeoutlier = FALSE)
}
\arguments{
\item{object}{count matrix with features in rows and samples in columns}

\item{...}{additional argument list that might be used}

\item{split}{indicator variable on whether it is for multiple slides}

\item{probs}{numeric vector of probabilities with values in [0,1] passed to quantile}

\item{removeoutlier}{indicator on whether to remove outliers, default: FALSE}

\item{probenum}{a vector of numbers of probes in each gene}

\item{BGmod}{a list of sizefact, sizefact, countmat, and id (if it is for multiple slides)}
}
\value{
a valid S4 object with probabilities in phenoData

a matrix of quantile range in rows and probs in columns
}
\description{
Compute Quantile Range, a metric representing signal strength for QC purpose

Compute Quantile Range, a metric representing signal strength for QC purpose
}
\examples{
data(demoData)
demoData <- fitPoisBG(demoData, size_scale = "sum")
demoData <- diagPoisBG(demoData)
demoData <- aggreprobe(demoData, use = "cor")
Biobase::notes(demoData)$disper
demoData <- QuanRange(demoData, split = FALSE, probs = c(0.75, 0.8, 0.9, 0.95))

data(demoData)
demoData <- fitPoisBG(demoData, groupvar = "slide name")
demoData <- diagPoisBG(demoData, split = TRUE)
demoData <- aggreprobe(demoData, use = "cor")
Biobase::notes(demoData)$disper_sp
demoData <- QuanRange(demoData, split = TRUE, probs = c(0.75, 0.8, 0.9, 0.95))
}
