% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{labelCuts}
\alias{labelCuts}
\title{Creates labels based on a discretization definition.}
\usage{
labelCuts(
  breakPoints,
  round_digits = 1,
  signif_digits = 3,
  collapse = "-",
  infBins = FALSE
)
}
\arguments{
\item{breakPoints}{The exact values you want as boundaries for your bins}

\item{round_digits}{Number of digits to cut round labels to.}

\item{signif_digits}{Number of significant digits to specify.}

\item{collapse}{Character to separate the labels}

\item{infBins}{use >/< as labels on the edge bins}
}
\value{
A vector of histogram axis labels.
}
\description{
If you are building a histogram of binned values, you want to have labels for
your bins that correspond to the ranges you used to bin. This function takes
the breakpoints that define your bins and produces nice-looking labels for
your histogram plot.
}
\details{
\code{labelCuts} will take a cut group, (e.g., a quantile division of 
some signal), and give you clean labels (similar to the cut method).
}
