% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specificity-plots.R
\name{calcSummarySignal}
\alias{calcSummarySignal}
\title{The function calcSummarySignal takes the input BED file(s) 
in form of GRanges or GRangesList object, overlaps 
it with all defined open chromatin regions across 
conditions (e.g. cell types) and returns a matrix, 
where each row is the input genomic region 
(if overlap was found), each column is a condition, 
and the value is a meam signal from regions where
overlap was found.}
\usage{
calcSummarySignal(query, signalMatrix)
}
\arguments{
\item{query}{Genomic regions to be analyzed. Can be GRanges or GRangesList 
object.}

\item{signalMatrix}{Matrix with signal values in predfined regions, where
rows are predefined genomic regions, columns are conditions 
(e.g. cell types in which the signal was measured). 
First column contains information about the genomic region in 
following form: chr_start_end. 
Can be either data.frame or data.table object.}
}
\value{
A list with named components:
           signalSummaryMatrix - data.table with cell specific open chromatin signal
                          values for query regions
           matrixStats - data.frame containing boxplot stats for individual 
                          cell type
}
\description{
The function calcSummarySignal takes the input BED file(s) 
in form of GRanges or GRangesList object, overlaps 
it with all defined open chromatin regions across 
conditions (e.g. cell types) and returns a matrix, 
where each row is the input genomic region 
(if overlap was found), each column is a condition, 
and the value is a meam signal from regions where
overlap was found.
}
\examples{
signalSummaryList = calcSummarySignal(vistaEnhancers, exampleOpenSignalMatrix_hg19)
}
