% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partition-plots.R
\name{calcPartitions}
\alias{calcPartitions}
\title{Calculates the distribution of overlaps between
query and arbitrary genomic partitions}
\usage{
calcPartitions(
  query,
  partitionList,
  remainder = "intergenic",
  bpProportion = FALSE
)
}
\arguments{
\item{query}{GRanges or GRangesList with regions to classify}

\item{partitionList}{an ORDERED (if bpProportion=FALSE) and NAMED list of
genomic partitions GRanges. This list must be in priority order; the
input will be assigned to the first partition it overlaps.
bpProportion=TRUE, the list does not need ordering.}

\item{remainder}{A character vector to assign any query regions that do
not overlap with anything in the partitionList. Defaults to "intergenic"}

\item{bpProportion}{logical indicating if overlaps should be calculated based
on number of base pairs overlapping with each partition.
bpProportion=FALSE does overlaps in priority order,
bpProportion=TRUE counts number of overlapping
base pairs between query and each partition.}
}
\value{
A data.frame assigning each element of a GRanges object to a
    partition from a previously provided partitionList.
}
\description{
Takes a GRanges object, then assigns each element to a partition from the
provided partitionList, and then tallies the number of regions assigned to
each partition. A typical example of partitions is promoter, exon, intron,
etc; this function will yield the number of each for a query GRanges object
There will be a priority order to these, to account for regions that may
overlap multiple genomic partitions.
}
\examples{
partitionList = genomePartitionList(geneModels_hg19$genesGR,
                                    geneModels_hg19$exonsGR,
                                    geneModels_hg19$threeUTRGR,
                                    geneModels_hg19$fiveUTRGR)
calcPartitions(vistaEnhancers, partitionList)
}
