% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chrom-plots.R
\name{calcChromBins}
\alias{calcChromBins}
\title{Calculates the distribution of a query set over the genome}
\usage{
calcChromBins(query, bins)
}
\arguments{
\item{query}{A GenomicRanges or GenomicRangesList object with query regions}

\item{bins}{Pre-computed bins (as a GRangesList object) to aggregate
over; for example, these could be genome bins}
}
\value{
A data.table showing where on which chromosomes 
   ranges are distributed.
}
\description{
Returns a data.table showing counts of regions from the query that overlap
with each bin.
In other words, where on which chromosomes are the ranges distributed?
You must provide binned regions. Only the midpoint of each query region is
used to test for overlap with the bin regions.
}
\examples{

chromSizes = getChromSizes("hg19")
genomeBins  = getGenomeBins(chromSizes)
chromDistribution = calcChromBins(vistaEnhancers, genomeBins)

vistaSftd = GenomicRanges::shift(vistaEnhancers, 100000)
vistaSftd2 = GenomicRanges::shift(vistaEnhancers, 200000)
calcChromBins(vistaEnhancers, GRangesList(vistaSftd, vistaSftd2))
}
