% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modlineq.R
\name{modlineq}
\alias{modlineq}
\title{Modular System of Linear Equation Solver (MLE)}
\usage{
modlineq(a, b, n, no.sol = 0L)
}
\arguments{
\item{a}{An integer or a vector of integers.}

\item{b}{An integer or a vector of integers.}

\item{n}{An integer or a vector of integers.}

\item{no.sol}{Values to return when the equation is not solvable or yield
the value 0. Default is 0.}
}
\value{
If the solution is exact, then a numerical vector will be returned,
otherwise, if there is not exact solution for some coordinate, the a list
carrying the element on the diagonal matrix and a translation vector will
be returned.
}
\description{
If \eqn{a, b}, and  \eqn{c} are integer vectors, this function
try to find, at each coordinate, the solution of the MLE
\eqn{a x = b}  mod \eqn{n}. If the MLE \eqn{a x = b mod n} has not
solutions (see \code{\link[numbers]{modlin}}), the value reported for the
coordinate will be 0 and the corresponding translation.
}
\details{
For \eqn{a, b}, and \eqn{c} integer scalars, it is just a
wrapper function to call \code{\link[numbers]{modlin}}.
}
\examples{
## Set the vector x, y, and m.
x <- c(9,32,24,56,60,27,28,5)
y <-  c(8,1,0,56,60,0,28,2)
modulo <- c(64,125,64,64,64,64,64,64)

## Try to solve the modular equation a x = b mod n
m <- modlineq(a = x, b = y, n = modulo)
m

## Or in matrix form 
diag(m)

## The reverse mapping is an affine transformation
mt <- modlineq(a = y, b = x, n = modulo, no.sol = 1L)
mt

## That is, vector 'x' is revovered with the transformaiton
(y \%*\% diag(mt$diag) + mt$translation) \%\% modulo

# Or
cat("\n---- \n")

(y \%*\% diag(mt$diag) + mt$translation) \%\% modulo == x
}
