% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gs_dendro.R
\name{gs_dendro}
\alias{gs_dendro}
\title{Dendrogram of the gene set enrichment results}
\usage{
gs_dendro(
  res_enrich,
  gtl = NULL,
  n_gs = nrow(res_enrich),
  gs_ids = NULL,
  gs_dist_type = "kappa",
  clust_method = "ward.D2",
  color_leaves_by = "z_score",
  size_leaves_by = "gs_pvalue",
  color_branches_by = "clusters",
  create_plot = TRUE
)
}
\arguments{
\item{res_enrich}{A \code{data.frame} object, storing the result of the functional
enrichment analysis. See more in the main function, \code{\link[=GeneTonic]{GeneTonic()}}, to see the
formatting requirements.}

\item{gtl}{A \code{GeneTonic}-list object, containing in its slots the arguments
specified above: \code{dds}, \code{res_de}, \code{res_enrich}, and \code{annotation_obj} - the names
of the list \emph{must} be specified following the content they are expecting}

\item{n_gs}{Integer value, corresponding to the maximal number of gene sets to
be included (from the top ranked ones). Defaults to the number of rows of
\code{res_enrich}}

\item{gs_ids}{Character vector, containing a subset of \code{gs_id} as they are
available in \code{res_enrich}. Lists the gene sets to be included, additionally to
the ones specified via \code{n_gs}. Defaults to NULL.}

\item{gs_dist_type}{Character string, specifying which type of similarity (and
therefore distance measure) will be used. Defaults to \code{kappa}, which uses
\code{\link[=create_kappa_matrix]{create_kappa_matrix()}}}

\item{clust_method}{Character string defining the agglomeration method to be
used for the hierarchical clustering. See \code{\link[stats:hclust]{stats::hclust()}} for details, defaults
to \code{ward.D2}}

\item{color_leaves_by}{Character string, which columns of \code{res_enrich} will
define the color of the leaves. Defaults to \code{z_score}}

\item{size_leaves_by}{Character string, which columns of \code{res_enrich} will
define the size of the leaves. Defaults to the \code{gs_pvalue}}

\item{color_branches_by}{Character string, which columns of \code{res_enrich} will
define the color of the branches. Defaults to \code{clusters}, which calls
\code{\link[dynamicTreeCut:cutreeDynamic]{dynamicTreeCut::cutreeDynamic()}} to define the clusters}

\item{create_plot}{Logical, whether to create the plot as well.}
}
\value{
A dendrogram object is returned invisibly, and a plot can be generated
as well on that object.
}
\description{
Calculate (and plot) the dendrogram of the gene set enrichment results
}
\examples{

library("macrophage")
library("DESeq2")
library("org.Hs.eg.db")
library("AnnotationDbi")

# dds object
data("gse", package = "macrophage")
dds_macrophage <- DESeqDataSet(gse, design = ~ line + condition)
rownames(dds_macrophage) <- substr(rownames(dds_macrophage), 1, 15)
dds_macrophage <- estimateSizeFactors(dds_macrophage)

# annotation object
anno_df <- data.frame(
  gene_id = rownames(dds_macrophage),
  gene_name = mapIds(org.Hs.eg.db,
    keys = rownames(dds_macrophage),
    column = "SYMBOL",
    keytype = "ENSEMBL"
  ),
  stringsAsFactors = FALSE,
  row.names = rownames(dds_macrophage)
)

# res object
data(res_de_macrophage, package = "GeneTonic")
res_de <- res_macrophage_IFNg_vs_naive

# res_enrich object
data(res_enrich_macrophage, package = "GeneTonic")
res_enrich <- shake_topGOtableResult(topgoDE_macrophage_IFNg_vs_naive)
res_enrich <- get_aggrscores(res_enrich, res_de, anno_df)

gs_dendro(res_enrich,
  n_gs = 100
)
}
