% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gs_distances.R
\name{create_kappa_matrix}
\alias{create_kappa_matrix}
\title{Compute the kappa matrix for enrichment results}
\usage{
create_kappa_matrix(
  res_enrich,
  gtl = NULL,
  n_gs = nrow(res_enrich),
  gs_ids = NULL
)
}
\arguments{
\item{res_enrich}{A \code{data.frame} object, storing the result of the functional
enrichment analysis. See more in the main function, \code{\link[=GeneTonic]{GeneTonic()}}, to see the
formatting requirements.}

\item{gtl}{A \code{GeneTonic}-list object, containing in its slots the arguments
specified above: \code{dds}, \code{res_de}, \code{res_enrich}, and \code{annotation_obj} - the names
of the list \emph{must} be specified following the content they are expecting}

\item{n_gs}{Integer value, corresponding to the maximal number of gene sets to
be included (from the top ranked ones). Defaults to the number of rows of
\code{res_enrich}}

\item{gs_ids}{Character vector, containing a subset of \code{gs_id} as they are
available in \code{res_enrich}. Lists the gene sets to be included, additionally to
the ones specified via \code{n_gs}. Defaults to NULL.}
}
\value{
A matrix with the kappa scores between gene sets
}
\description{
Compute the kappa matrix for enrichment results, as a measure of overlap
}
\examples{

# res_enrich object
data(res_enrich_macrophage, package = "GeneTonic")
res_enrich <- shake_topGOtableResult(topgoDE_macrophage_IFNg_vs_naive)

kmat <- create_kappa_matrix(res_enrich[1:200, ])
dim(kmat)
}
\seealso{
\code{\link[=gs_mds]{gs_mds()}}
}
