% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_inputs.R
\name{checkup_GeneTonic}
\alias{checkup_GeneTonic}
\title{Checking the input objects for GeneTonic}
\usage{
checkup_GeneTonic(dds, res_de, res_enrich, annotation_obj, verbose = FALSE)
}
\arguments{
\item{dds}{A \code{DESeqDataSet} object, normally obtained after running your data
through the \code{DESeq2} framework.}

\item{res_de}{A \code{DESeqResults} object. As for the \code{dds} parameter, this is
also commonly used in the \code{DESeq2} framework.}

\item{res_enrich}{A \code{data.frame} object, storing the result of the functional
enrichment analysis. See more in the main function, \code{\link[=GeneTonic]{GeneTonic()}}, to check the
formatting requirements (a minimal set of columns should be present).}

\item{annotation_obj}{A \code{data.frame} object, containing two columns, \code{gene_id}
with a set of unambiguous identifiers (e.g. ENSEMBL ids) and \code{gene_name},
containing e.g. HGNC-based gene symbols.}

\item{verbose}{Logical, to control level of verbosity of the messages generated}
}
\value{
Invisible NULL
}
\description{
Checking the input objects for GeneTonic, whether these are all set for running
the app
}
\details{
Some suggestions on the requirements for each parameter are returned in the
error messages.
}
\examples{

library("macrophage")
library("DESeq2")
library("org.Hs.eg.db")
library("AnnotationDbi")

# dds object
data("gse", package = "macrophage")
dds_macrophage <- DESeqDataSet(gse, design = ~ line + condition)
rownames(dds_macrophage) <- substr(rownames(dds_macrophage), 1, 15)
dds_macrophage <- estimateSizeFactors(dds_macrophage)

# annotation object
anno_df <- data.frame(
  gene_id = rownames(dds_macrophage),
  gene_name = mapIds(org.Hs.eg.db,
    keys = rownames(dds_macrophage),
    column = "SYMBOL",
    keytype = "ENSEMBL"
  ),
  stringsAsFactors = FALSE,
  row.names = rownames(dds_macrophage)
)

# res object
data(res_de_macrophage, package = "GeneTonic")
res_de <- res_macrophage_IFNg_vs_naive

# res_enrich object
data(res_enrich_macrophage, package = "GeneTonic")
res_enrich <- shake_topGOtableResult(topgoDE_macrophage_IFNg_vs_naive)
res_enrich <- get_aggrscores(res_enrich, res_de, anno_df)

checkup_GeneTonic(
  dds = dds_macrophage,
  res_de = res_de,
  res_enrich = res_enrich,
  annotation_obj = anno_df
)
# if all is fine, it should return an invisible NULL and a simple message
}
