% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/leafCutter.R
\name{removeSameExon}
\alias{removeSameExon}
\title{Remove exon duplicates}
\usage{
removeSameExon(exons)
}
\arguments{
\item{exons}{GRanges object with exons}
}
\value{
GRanges object with unique exons
}
\description{
Removes structural duplicates of exons in a GRanges object
}
\examples{
gtf <- rtracklayer::import(system.file("extdata","example_gtf.gtf",
package = "GeneStructureTools"))
exons <- gtf[gtf$type=="exon"]
exons.duplicated <- c(exons[1:4], exons[1:4])
length(exons.duplicated)
exons.deduplicated <- removeSameExon(exons.duplicated)
length(exons.deduplicated)
}
\seealso{
Other gtf manipulation: \code{\link{UTR2UTR53}},
  \code{\link{addBroadTypes}},
  \code{\link{exonsToTranscripts}},
  \code{\link{filterGtfOverlap}},
  \code{\link{removeDuplicateTranscripts}},
  \code{\link{reorderExonNumbers}}
}
\author{
Beth Signal
}
