% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cy3Network.R
\name{cy3Network}
\alias{cy3Network}
\title{visualize the network by Cy3}
\usage{
cy3Network(
  gR = graphNEL(),
  ...,
  stringify = FALSE,
  species = "Homo sapiens",
  style = "Marquee",
  widths = c(0.25, 5)
)
}
\arguments{
\item{gR}{an object of \link[graph:graphNEL-class]{graphNEL}}

\item{...}{parameters will be passed to \link[RCy3]{createNetworkFromGraph}}

\item{stringify}{Run STRINGify or not}

\item{species}{if stringify is TRUE, teh species will be used to retreive
the nodes and edges properties.}

\item{style}{The default style when create the network}

\item{widths}{The link width range.}
}
\value{
The network SUID.
}
\description{
Using RCy3 to visualize the network.
}
\examples{
data("ce.miRNA.map")
data("example.data")
data("ce.interactionmap")
data("ce.IDsMap")
sifNetwork<-buildNetwork(example.data$ce.bind, ce.interactionmap, level=2)
cifNetwork<-filterNetwork(rootgene=ce.IDsMap["DAF-16"], sifNetwork=sifNetwork, 
  exprsData=uniqueExprsData(example.data$ce.exprData, "Max", condenseName='logFC'),
  mergeBy="symbols",
  miRNAlist=as.character(ce.miRNA.map[ , 1]), tolerance=1)
gR<-polishNetwork(cifNetwork)
if(interactive()){
  cy3Network(gR)
}
}
