% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/browseNetwork.R
\name{browseNetwork}
\alias{browseNetwork}
\title{browse network}
\usage{
browseNetwork(
  gR = graphNEL(),
  layoutType = c("fdp", "dot", "neato", "twopi", "circo"),
  width = NULL,
  height = NULL,
  maxNodes = 500,
  ...
)
}
\arguments{
\item{gR}{an object of \link[graph:graphNEL-class]{graphNEL}}

\item{layoutType}{layout type. see \link[Rgraphviz]{GraphvizLayouts}}

\item{width}{width of the figure}

\item{height}{height of the figure}

\item{maxNodes}{max nodes number to plot. Because if there are two many nodes,
the running time will be too long.}

\item{...}{parameters used by \link[Rgraphviz]{GraphvizLayouts}}
}
\value{
An object of class htmlwidget that will intelligently print itself 
        into HTML in a variety of contexts including the R console, 
        within R Markdown documents, and within Shiny output bindings.
}
\description{
plot network generated by \link{polishNetwork}
}
\examples{
data("ce.miRNA.map")
data("example.data")
data("ce.interactionmap")
data("ce.IDsMap")
sifNetwork<-buildNetwork(example.data$ce.bind, ce.interactionmap, level=2)
cifNetwork<-filterNetwork(rootgene=ce.IDsMap["DAF-16"], sifNetwork=sifNetwork, 
  exprsData=uniqueExprsData(example.data$ce.exprData, "Max", condenseName='logFC'),
  mergeBy="symbols",
  miRNAlist=as.character(ce.miRNA.map[ , 1]), tolerance=1)
gR<-polishNetwork(cifNetwork)
browseNetwork(gR)
}
\keyword{plot}
