% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/GeneBreakMethods.R
\docType{methods}
\name{bpPlot,CopyNumberBreakPoints-method}
\alias{bpPlot}
\alias{bpPlot,CopyNumberBreakPoints-method}
\title{bpPlot}
\usage{
\S4method{bpPlot}{CopyNumberBreakPoints}(object, plot.chr = NULL,
  plot.ylim = 15, fdr.threshold = 0.1, add.jitter = FALSE)
}
\arguments{
\item{object}{An object of class \linkS4class{CopyNumberBreakPoints} or \linkS4class{CopyNumberBreakPointGenes}}

\item{plot.chr}{A vector with chromosome(s) to plot. All chromosomes will be plotted when NULL is used.}

\item{plot.ylim}{An integer giving the max y coordinate.}

\item{fdr.threshold}{The FDR threshold to label recurrent breakpoint genes with their gene name}

\item{add.jitter}{Logical. If TRUE, function jitter will be used for the y position of gene labels}
}
\value{
calls plot function
}
\description{
Plots breakpoint frequencies per chromosome
}
\details{
The plot includes breakpoint locations and breakpoint gene frequencies. Genes that are recurrently affected are labeled with their gene name.
}
\examples{
data( copynumber.data.chr20 )
data( ens.gene.ann.hg18 )
bp <- getBreakpoints( copynumber.data.chr20 )
bp <- bpFilter( bp )
bp <- addGeneAnnotation( bp, ens.gene.ann.hg18 )
bp <- bpGenes( bp )
bp <- bpStats( bp )

bpPlot( bp, c(20) )
}

