% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/GeneBreakMethods.R
\docType{methods}
\name{bpGenes,CopyNumberBreakPointGenes-method}
\alias{bpGenes}
\alias{bpGenes,CopyNumberBreakPointGenes-method}
\title{bpGenes}
\usage{
\S4method{bpGenes}{CopyNumberBreakPointGenes}(object)
}
\arguments{
\item{object}{An object of class \linkS4class{CopyNumberBreakPointGenes}}
}
\value{
Returns an object of class \linkS4class{CopyNumberBreakPointGenes} with gene-breakpoint information
}
\description{
Indentifies genes affected by breakpoint locations.
}
\details{
This step requires feature-to-gene annotations added to the input object (see \code{?addGeneAnnotation}).
}
\examples{
data( copynumber.data.chr20 )
data( ens.gene.ann.hg18 )

bp <- getBreakpoints( copynumber.data.chr20 )
bp <- bpFilter( bp )
bp <- addGeneAnnotation( bp, ens.gene.ann.hg18 )
bp <- bpGenes( bp )

## options to inspect the data
bp
accessOptions( bp )
}

