% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.R
\name{TvTi}
\alias{TvTi}
\title{Construct transition-transversion plot}
\usage{
TvTi(
  x,
  fileType = NULL,
  y = NULL,
  clinData = NULL,
  type = "Proportion",
  lab_Xaxis = TRUE,
  lab_txtAngle = 45,
  palette = c("#D53E4F", "#FC8D59", "#FEE08B", "#E6F598", "#99D594", "#3288BD"),
  tvtiLayer = NULL,
  expecLayer = NULL,
  sort = "none",
  clinLegCol = NULL,
  clinVarCol = NULL,
  clinVarOrder = NULL,
  clinLayer = NULL,
  progress = TRUE,
  out = "plot",
  sample_order_input,
  layers = NULL,
  return_plot = FALSE
)
}
\arguments{
\item{x}{Object of class data frame with rows representing transitions and
transversions. The data frame must contain the following columns 'sample',
reference' and 'variant' or alternatively "Tumor_Sample_Barcode",
"Reference_Allele", "Tumor_Seq_Allele1", "Tumor_Seq_Allele2" depending on the
argument supplied to the fileType parameter. (required)}

\item{fileType}{Character string specifying the format the input given to
parameter x is in, one of 'MAF', 'MGI'. The former option requires the data
frame given to x to contain the following column names
"Tumor_Sample_Barcode", "Reference_Allele", "Tumor_Seq_Allele1",
"Tumor_Seq_Allele2" the later option requires the data frame givin to x to
contain the following column names "reference", "variant" and "sample".
(required)}

\item{y}{Named vector or data frame representing the expected transition and 
transversion rates. Either option must name transition and transverions as
follows: "A->C or T->G (TV)", "A->G or T->C (TI)", "A->T or T->A (TV)",
 "G->A or C->T (TI)", "G->C or C->G (TV)", "G->T or C->A (TV)". If specifying
 a data frame, the data frame must contain the following columns names
 "Prop", "trans_tranv" (optional see vignette).}

\item{clinData}{Object of class data frame with rows representing clinical
data. The data frame should be in "long format" and columns must be names as
"sample", "variable", and "value" (optional see details and vignette).}

\item{type}{Character string specifying if the plot should display the
Proportion or Frequency of transitions/transversions observed. One of
"Proportion" or "Frequency", defaults to "Proportion".}

\item{lab_Xaxis}{Boolean specifying whether to label the x-axis in the plot.}

\item{lab_txtAngle}{Integer specifying the angle of labels on the x-axis of
the plot.}

\item{palette}{Character vector of length 6 specifying colours for each
of the six possible transition transversion types.}

\item{tvtiLayer}{Valid ggplot2 layer to be added to the main plot.}

\item{expecLayer}{Valid ggplot2 layer to be added to the expected sub-plot.}

\item{sort}{Character string specifying the sort order of the sample
variables in the plot. Arguments to this parameter should be "sample",
"tvti", or "none" to sort the x-axis by sample name, transition transversion
frequency, or no sort respectively.}

\item{clinLegCol}{Integer specifying the number of columns in the legend for
the clinical data, only valid if argument is supplied to parameter clinData.}

\item{clinVarCol}{Named character vector specifying the mapping of colours
to variables in the variable column of the data frame supplied to clinData
(ex. "variable"="colour").}

\item{clinVarOrder}{Character vector specifying the order in which to plot
variables in the variable column of the argument given to the parameter
clinData. The argument supplied to this parameter should have the same unique
length and values as in the variable column of the argument supplied to 
parameter clinData (see vignette).}

\item{clinLayer}{Valid ggplot2 layer to be added to the clinical sub-plot.}

\item{progress}{Boolean specifying if progress bar should be displayed for
the function.}

\item{out}{Character vector specifying the the object to output, one of
"data", "grob", or "plot", defaults to "plot" (see returns).}

\item{sample_order_input}{Sample orders to be used}

\item{layers}{ggplot object to be added to proportions plot}

\item{return_plot}{Return as ggplot object? Only returns main plot}
}
\value{
One of the following, a list of dataframes containing data to be
plotted, a grob object, or a plot.
}
\description{
Given a data frame construct a plot displaying the proportion or frequency of
transition and transversion types observed in a cohort.
}
\details{
TvTi is a function designed to display proportion or frequency
of transitions and transversion seen in a data frame supplied to parameter x.
}
\examples{
TvTi(brcaMAF, type='Frequency',
palette=c("#77C55D", "#A461B4", "#C1524B", "#93B5BB", "#4F433F", "#BFA753"),
lab_txtAngle=60, fileType="MAF")
}
