% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotTracks.R
\name{plotTracks}
\alias{plotTracks}
\title{Plot offtargets as manhantann plots or along all chromosomes with one track 
per chromosome, or scatter plot for two selected measurements}
\usage{
plotTracks(
  offTargetFile,
  sep = "\\t",
  header = TRUE,
  gRNA.size = 20L,
  PAM.size = 3L,
  cleavage.position = 19L,
  chromosome.order = paste0("chr", c(1:22, "X", "Y", "M")),
  xlab = "Chromosome Size (bp)",
  ylab = "Peak Score",
  score.col = c("peak_score", "n.distinct.UMIs", "total.match", "gRNA.match",
    "total.mismatch.bulge", "gRNA.mismatch.bulge", "predicted_cleavage_score"),
  transformation = c("log10", "none"),
  title = "",
  axis.title.size = 12,
  axis.label.size = 8,
  strip.text.y.size = 9,
  off.target.line.size = 0.6,
  on.target.line.size = 1,
  on.target.score = 1,
  on.target.color = "red",
  off.target.color = "black",
  strip.text.y.angle = 0,
  scale.grid = c("free_x", "fixed", "free", "free_y"),
  plot.type = c("manhattan", "tracks", "scatter"),
  family = "serif",
  x.sep = 6e+06,
  plot.zero.logscale = 1e-08,
  scale.chrom = TRUE
)
}
\arguments{
\item{offTargetFile}{The file path containing off-targets generated
from GUIDEseqAnalysis}

\item{sep}{The separator in the file, default to tab-delimited}

\item{header}{Indicates whether the input file contains a header,
default to TRUE}

\item{gRNA.size}{The size of the gRNA, default 20}

\item{PAM.size}{PAM length, default 3}

\item{cleavage.position}{the cleavage position of Cas
nuclease, default to 19 for SpCas9.}

\item{chromosome.order}{The chromosome order to plot from top to bottom}

\item{xlab}{The x-asix label, default to Chromosome Size (bp)}

\item{ylab}{The y-asix label, default to Peak Score. Change it to
be consistent with the score.col}

\item{score.col}{The column used as y values in the plot. Available choices
are peak_score, n.distinct.UMIs, total.match, gRNA.match, total.mismatch.bulge,
gRNA.mismatch.bulge, and predicted_cleavage_score. When plot.type is set to
scatter, a vector of size two can be set. Otherwise, a scatter plot with log10
transformed n.distinct.UMIs and log10 transformed predicted_cleavage_score 
will be plotted.}

\item{transformation}{Indicates whether plot the y-value in log10 scale or
in the original scale. When scale.col is set to total.match, gRNA.match,
total.mismatch.bulge, and gRNA.mismatch.bulge, transformation will
not be applied and the data will be plotted in the original scale.
When plot.type is set to "scatter", a vector of size two is required when 
score.col is a vector of size two. Examples are c("log10", "log10"), 
c("none", "none"), c(log10", "none"), and c("none", "log10").}

\item{title}{The figure title, default to none.}

\item{axis.title.size}{The font size for the axis labels, default to 12}

\item{axis.label.size}{The font size for the tick labels, default to 8}

\item{strip.text.y.size}{The font size for the strip labels, default to 9}

\item{off.target.line.size}{The line size to depict the off-targets, default
to 0.6}

\item{on.target.line.size}{The line size to depict the on-targets, default
to 1}

\item{on.target.score}{The score for the on-target, default to 1 for CFD
scoring system. This is the maximum score in the chosen scoring system.
Change it accordingly if different off-target scoring system is used.}

\item{on.target.color}{The line color to depict the on-targets, default
to red}

\item{off.target.color}{The line color to depict the off-targets, default
to black}

\item{strip.text.y.angle}{The angel for the y strip text, default to 0.
Set it to 45 if angled representation is desired}

\item{scale.grid}{Used to set the scales in facet_grid, default to free_x,
meaning that scales vary across different x-axis, but fixed in y-axis.
Other options are fixed, free, and free_y meaning that scales shared
across all facets, vary across both x- and y- axises, and vary across 
y-axis only, respectively.
For details, please type ?ggplot2::facet_grid}

\item{plot.type}{Plot type as tracks by individual chromosome or
manhattan plot with all chromosome in one plot}

\item{family}{font family, default to sans (Arial). Other options are 
serif (Times New Roman) and mono (Courier). It is possible to use custom 
fonts with the extrafont package with the following commands
install.packages("extrafont")
library(extrafont)
font_import()
loadfonts(device = "postscript")}

\item{x.sep}{For transforming the x-axis to allow sufficient spaces
between small chromosomes default to 6000000}

\item{plot.zero.logscale}{Specifying "none" to filter out score.col with
zeros when plotting in log10 scale. Specify a very small numeric number
if you intend to show the zeros in log scale in the figure. If users
specify a number that's bigger than any positive score, plot.zero.logscale
will be set to the minimum positive score divided by 10.}

\item{scale.chrom}{Applicable to manhatann plot only.
TRUE or FALSE default to TRUE to space offtargets evenly
along x-axis.}
}
\value{
a ggplot object
}
\description{
Plot offtargets as manhantann plots or along all chromosomes with one track 
per chromosome, or scatter plot for two selected measurements
}
\examples{
if (interactive())
{
   offTargetFilePath <- system.file("extdata/forVisualization",
      "offTargetsInPeakRegions.xls",
       package = "GUIDEseq")
  fig1 <- plotTracks(offTargetFile = offTargetFilePath)
  fig1
  fig2 <- plotTracks(offTargetFile = offTargetFilePath,
    score.col = "total.mismatch.bulge",
    ylab = "Total Number of Mismatches and Bulges")
  fig2
  fig3 <- plotTracks(offTargetFile = offTargetFilePath,
     score.col = "total.match",
     ylab = "Total Number of Matches")
  fig3
  fig4 <- plotTracks(offTargetFile = offTargetFilePath,
      score.col = "gRNA.match",
      ylab = "Number of Matches in gRNA")
  fig4
  fig5 <- plotTracks(offTargetFile = offTargetFilePath,
      score.col = "gRNA.mismatch.bulge",
      ylab = "Number of Mismatches and Bulges in gRNA")
  fig5
  fig6 <- plotTracks(offTargetFile = offTargetFilePath,
     score.col = "predicted_cleavage_score",
     ylab = "CFD Score",
     scale.grid = "fixed",
     transformation = "none")
 fig6
 
 ## manhattan plot
  fig <- plotTracks(offTargetFile = offTargetFilePath,
        score.col = "total.mismatch.bulge", axis.title.size =9,
        plot.type =  "manhattan",
        ylab = "Number of Mismatches and Bulges in gRNA Plus PAM")
   fig
  fig <- plotTracks(offTargetFile = offTargetFilePath,
       score.col = "total.match", axis.title.size =9,
       plot.type =  "manhattan",
       ylab = "Number of Matches in gRNA Plus PAM")
   fig
fig <- plotTracks(offTargetFile = offTargetFilePath,
                 score.col = "gRNA.match",axis.title.size =9,
                 plot.type =  "manhattan",
                 ylab = "Number of Matches in gRNA")
fig
fig <- plotTracks(offTargetFile = offTargetFilePath,
                 score.col = "gRNA.mismatch.bulge", axis.title.size =9, 
                 plot.type =  "manhattan",
                 ylab = "Number of Mismatches and Bulges in gRNA")
  fig
  
  plotTracks(offTargetFile = offTargetFilePath,
      #'score.col = "predicted_cleavage_score",
      axis.title.size =9, family = "serif", plot.zero.logscale = 1e-6,
      plot.type =  "manhattan", transformation = "log10",
      ylab = "CFD Score")
      
  plotTracks(offTargetFile = offTargetFilePath,
       score.col = "peak_score",
       axis.title.size =9, 
       plot.type =  "manhattan",
       ylab = "Number of Insertion Events")
       
  plotTracks(offTargetFile = offTargetFilePath,
       score.col = "n.distinct.UMIs",
       axis.title.size =9, 
       plot.type =  "manhattan",
       ylab = "Number of Insertion Events")
       
 # default scatter plot with blue line from fitting the entire dataset
 # and the red line from fitting the subset with CFD score > 0
  plotTracks(offTargetFile = offTargetFilePath,
      axis.title.size =9, plot.zero.logscale = 1e-8,
      plot.type =  "scatter")
      
 # select the x, y, the transformation of x and y,
 # and the labels on the scatter plot
 
  plotTracks(offTargetFile = offTargetFilePath,
      axis.title.size =9,
      score.col = c("n.distinct.UMIs", "predicted_cleavage_score"), 
      transformation = c("log10", "log10"),
      plot.type =  "scatter", plot.zero.logscale = 1e-8,
      xlab = "log10(Number of Insertion Events)",
      ylab = "log10(CFD score)")
       
 }
}
\author{
Lihua Julie Zhu
}
