% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotAlignedOfftargets.R
\name{plotAlignedOfftargets}
\alias{plotAlignedOfftargets}
\title{Plot offtargets aligned to the target sequence}
\usage{
plotAlignedOfftargets(
  offTargetFile,
  sep = "\\t",
  header = TRUE,
  gRNA.size = 20L,
  input.DNA.bulge.symbol = "^",
  input.RNA.bulge.symbol = "-",
  input.match.symbol = ".",
  plot.DNA.bulge.symbol = "DNA.bulge",
  plot.RNA.bulge.symbol = "-",
  plot.match.symbol = ".",
  color.DNA.bulge = "red",
  size.symbol = 3,
  color.values = c(A = "#B5D33D", T = "#AE9CD6", C = "#6CA2EA", G = "#FED23F", `-` =
    "gray", . = "white"),
  PAM = "GGG",
  body.tile.height = 2.5,
  header.tile.height = 3.6,
  hline.offset = 3.8,
  plot.top.n,
  insertion.score.column = c("n.distinct.UMIs", "peak_score"),
  insertion.score.column.prefix,
  width.IR = 2.5,
  width.RIR = 2.5,
  family = "sans",
  hjust = "middle",
  vjust = 0.5
)
}
\arguments{
\item{offTargetFile}{The path of the file offTargetsInPeakRegions.xls
that stores the offtargets to be plotted. This file is the
output file from the function GUIDEseqAnalysis.}

\item{sep}{Field delimiter for the file specified as
offTargetFile, default to tab dilimiter}

\item{header}{Indicates whether there is header in the file
specified as offTargetFile, default to TRUE}

\item{gRNA.size}{Size of the gRNA, default to 20 for SpCas9 system}

\item{input.DNA.bulge.symbol}{The symbol used to represent DNA bulges
in the file specified as offTargetFile, default to "^"}

\item{input.RNA.bulge.symbol}{The symbol used to represent RNA bulges
in the file specified as offTargetFile, default to "-"}

\item{input.match.symbol}{The symbol used to represent matched bases
in the file specified as offTargetFile, default to "."}

\item{plot.DNA.bulge.symbol}{The symbol used to represent DNA bulges
in the figure to be generated, default to DNA.bulge, i.e., the nucleotide
in the DNA bulge. Alternatively, you can specify a symbol to represent
all DNA bulges such as "I".}

\item{plot.RNA.bulge.symbol}{The symbol used to represent RNA bulges
in the figure to be generated, default to "-"}

\item{plot.match.symbol}{The symbol used to represent matched bases
in the figure to be generated, default to "."}

\item{color.DNA.bulge}{The color used to represent DNA bulges
in the figure to be generated, default to "red"}

\item{size.symbol}{The size used to plot the bases, and the symbols
of DNA/RNA bulges, default to 3}

\item{color.values}{The color used to represent different bases, DNA
bulges, and RNA bulges.}

\item{PAM}{PAM sequence in the target site, please update it to
the exact PAM sequence in the input target site.}

\item{body.tile.height}{Specifies the height of each plotting
tile around each base/symbol for offtargets, default to 2.5}

\item{header.tile.height}{Specifies the height of each plotting
tile around each base/symbol for the target sequence on the very
top, default to 3.6}

\item{hline.offset}{Specifies the offset from the top border to draw
the horizontal line below the gRNA sequence, default to 3.8. Increase it
to move the line down and decrease it to move the line up.}

\item{plot.top.n}{Optional. If not specified, all the offtargets
in the input file specified as offTargetFile will be included
in the plot. With a very large number of offtargets,
users can select the top n offtargets to be included in the plot.
For example, set plot.top.n = 20 to include only top 20 offtargets
in the plot. Please note offtargets are ordered by the n.distinct.UMIs or
peak_score from top to bottom.}

\item{insertion.score.column}{"n.distinct.UMIs" or "peak_score" to be included on}

\item{insertion.score.column.prefix}{to designate sample name e.g., S1 
which means that two of columns are named as S1.peak_score 
and S1.n.distinct.UMIs in the input file. Useful if the input file is
generated by the function combineOfftargets
the right side of the alignment as Insertion Events. Relative Insertion 
Rate (RIR) % is calculated as peak_score/n.distinct.UMIs 
divided by ontarget peak_score/n.distinct.UMIs. For example, RIR for ontarget
should be 100}

\item{width.IR}{For adjusting the width of the IR output}

\item{width.RIR}{For adjusting the width of the RIR output}

\item{family}{font family, default to sans (Arial). Other options are 
serif (Times New Roman) and mono (Courier). It is possible to use custom 
fonts with the extrafont package with the following commands
install.packages("extrafont")
library(extrafont)
font_import()
loadfonts(device = "postscript")}

\item{hjust}{horizontal alignment}

\item{vjust}{vertical alignment}
}
\value{
a ggplot object
}
\description{
Plot offtargets aligned to the target sequence
}
\examples{
offTargetFilePath <- system.file("extdata/forVisualization",
 "offTargetsInPeakRegions.xls",
 package = "GUIDEseq")
fig1 <- plotAlignedOfftargets(offTargetFile = offTargetFilePath,
    plot.top.n = 20,
    plot.match.symbol = ".",  
    plot.RNA.bulge.symbol = "-", 
    insertion.score.column = "peak_score")
fig1

fig2 <- plotAlignedOfftargets(offTargetFile = offTargetFilePath,
    plot.top.n = 20,
    plot.match.symbol = ".",  
    plot.RNA.bulge.symbol = "-", 
    insertion.score.column = "n.distinct.UMIs")
fig2

}
\author{
Lihua Julie Zhu
}
