% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusterSim.R
\name{clusterSim}
\alias{clusterSim}
\title{Semantic similarity between two gene clusters}
\usage{
clusterSim(
  cluster1,
  cluster2,
  semData,
  measure = "Wang",
  drop = "IEA",
  combine = "BMA"
)
}
\arguments{
\item{cluster1}{A set of gene IDs}

\item{cluster2}{Another set of gene IDs}

\item{semData}{GOSemSimDATA object}

\item{measure}{One of "Resnik", "Lin", "Rel", "Jiang", "TCSS" and "Wang" methods.}

\item{drop}{Evidence codes to drop; use \code{NULL} to keep all GO annotations}

\item{combine}{One of "max", "avg", "rcmax", "BMA" methods, used to combine multiple term scores.}
}
\value{
similarity
}
\description{
Semantic similarity between two gene clusters
}
\examples{
d <- godata('org.Hs.eg.db', ont = "MF", computeIC = FALSE)
cluster1 <- c("835", "5261", "241", "994")
cluster2 <- c("307", "308", "317", "321", "506", "540", "378", "388", "396")
clusterSim(cluster1, cluster2, semData = d, measure = "Wang")
}
\seealso{
\code{\link[=goSim]{goSim()}} \code{\link[=mgoSim]{mgoSim()}} \code{\link[=geneSim]{geneSim()}} \code{\link[=mgeneSim]{mgeneSim()}} \code{\link[=clusterSim]{clusterSim()}} \code{\link[=mclusterSim]{mclusterSim()}}
}
\author{
Guangchuang Yu \url{https://yulab-smu.top}
}
