% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/searchReferences.R
\name{searchReferences}
\alias{searchReferences}
\title{searchReferences function}
\usage{
searchReferences(host, referenceSetId, md5checksum = NA_character_,
  accession = NA_character_, nrows = Inf, responseSize = NA_integer_)
}
\arguments{
\item{host}{URL of GA4GH API data server.}

\item{referenceSetId}{The ReferenceSet to search.}

\item{md5checksum}{If specified, return the references for which the
md5checksum matches this string (case-sensitive, exact match).
See ReferenceSet::md5checksum for details.}

\item{accession}{If specified, return the references for which the accession
matches this string (case-sensitive, exact match).}

\item{nrows}{Number of rows of the data frame returned by this function.
If not defined, the function will return all entries. If the number of
available entries is less than the value of this this parameter, the function
will silently return only the available entries.}

\item{responseSize}{Specifies the number of entries to be returned by the
server until reach the number of rows defined in \code{nrows} parameter or
until get all available entries. If not defined, the server will return the
allowed maximum reponse size. Increasing this the value of this parameter will
reduce the number of requests and reducing the time required. The will not
respect this parameter if the value if larger than its maximum response size.}
}
\value{
\code{\link{DataFrame}} object.
}
\description{
Search for references (genome sequences, e.g. chromosomes).
}
\details{
This function requests \code{POST host/references/search}.
}
\examples{
host <- "http://1kgenomes.ga4gh.org/"
\dontrun{
referenceSetId <- searchReferenceSets(host, nrows = 1)$id
searchReferences(host, referenceSetId)
}
}
\references{
\href{https://ga4gh-schemas.readthedocs.io/en/latest/schemas/reference_service.proto.html#SearchReferences}{Official documentation}.
}
\seealso{
\code{\link{DataFrame}}, \code{\link{getReference}}
}
