% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/searchReadGroupSets.R
\name{searchReadGroupSets}
\alias{searchReadGroupSets}
\title{searchReadGroupSets function}
\usage{
searchReadGroupSets(host, datasetId, name = NA_character_,
  biosampleId = NA_character_, nrows = Inf, responseSize = NA_integer_)
}
\arguments{
\item{host}{URL of GA4GH API data server.}

\item{datasetId}{The dataset to search.}

\item{name}{Only return read group sets with this name
(case-sensitive, exact match).}

\item{biosampleId}{Specifying the id of a BioSample record will return only
readgroups with the given biosampleId.}

\item{nrows}{Number of rows of the data frame returned by this function.
If not defined, the function will return all entries. If the number of
available entries is less than the value of this this parameter, the function
will silently return only the available entries.}

\item{responseSize}{Specifies the number of entries to be returned by the
server until reach the number of rows defined in \code{nrows} parameter or
until get all available entries. If not defined, the server will return the
allowed maximum reponse size. Increasing this the value of this parameter will
reduce the number of requests and reducing the time required. The will not
respect this parameter if the value if larger than its maximum response size.}
}
\value{
\code{\link{DataFrame}} object.
}
\description{
Search for read group sets (sequence alignement, e.g BAM files).
}
\details{
This function requests \code{POST host/readgroupsets/search}
}
\examples{
host <- "http://1kgenomes.ga4gh.org/"
\dontrun{
datasetId <- searchDatasets(host, nrows = 1)$id
searchReadGroupSets(host, datasetId, nrows = 1)
}
}
\seealso{
\code{\link{DataFrame}}, \code{\link{getReadGroupSet}}
}
