% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getVariantSet.R
\name{getVariantSet}
\alias{getVariantSet}
\title{getVariantSet function.}
\usage{
getVariantSet(host, variantSetId, asVCFHeader = TRUE)
}
\arguments{
\item{host}{URL of GA4GH API data server.}

\item{variantSetId}{The ID of the VariantSet to be retrieved.}

\item{asVCFHeader}{If \code{TRUE} the function will return an
\code{\link{VCFHeader}} object (default), otherwise it will return an
\code{DataFrame}.}
}
\value{
\code{\link{DataFrame}} object. It can be converted
into \code{\link{VCFHeader}} object.
}
\description{
Get a variant set by its ID.
}
\details{
This function requests \code{GET host/variantsets/variantSetId}.
}
\examples{
host <- "http://1kgenomes.ga4gh.org/"
\dontrun{
datasetId <- searchDatasets(host, nrows = 1)$id
variantSetId <- searchVariantSets(host, datasetId, nrows = 1)$id
getVariantSet(host, variantSetId)

getVariantSet(host, variantSetId, asVCF = FALSE)
}
}
\seealso{
\code{\link{DataFrame}}, \code{\link{searchVariantSets}},
\code{\link{VCFHeader}}, \code{\link{makeVCFHeaderFromGA4GHResponse}}
}
