% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/5_plotFunctions.R
\name{PlotPies}
\alias{PlotPies}
\title{PlotPies}
\usage{
PlotPies(
  fsom,
  cellTypes,
  colorPalette = grDevices::colorRampPalette(c("white", "#00007F", "blue", "#007FFF",
    "cyan", "#7FFF7F", "yellow", "#FF7F00", "red", "#7F0000")),
  ...
)
}
\arguments{
\item{fsom}{FlowSOM object, as generated by \code{\link{FlowSOM}}}

\item{cellTypes}{Array of factors indicating the celltypes}

\item{colorPalette}{Color palette to use.}

\item{...}{Additional arguments to pass to \code{\link{PlotFlowSOM}}}
}
\value{
ggplot plot
}
\description{
Plot comparison with other clustering
}
\details{
Plot FlowSOM grid or tree, with pies indicating another clustering
   or manual gating result
}
\examples{
# Identify the files
fcs_file <- system.file("extdata", "68983.fcs", package = "FlowSOM")
gating_file <- system.file("extdata", "gatingResult.csv", package = "FlowSOM")

# Specify the cell types of interest for assigning one label per cell
cellTypes <- c("B cells",
               "gd T cells", "CD4 T cells", "CD8 T cells",
               "NK cells", "NK T cells")
                
# Load manual labels (e.g. GetFlowJoLabels can be used to extract labels from
# an fcs file)
 
gatingResult <- as.factor(read.csv(gating_file, header = FALSE)[, 1])


# Build a FlowSOM tree
flowSOM.res <- FlowSOM(fcs_file,
                       scale = TRUE, 
                       compensate = TRUE, 
                       transform = TRUE,
                       toTransform = 8:18, 
                       colsToUse = c(9, 12, 14:18),
                       nClus = 10,
                       seed = 1)
   
 # Plot pies indicating the percentage of cell types present in the nodes
 PlotPies(flowSOM.res,
          gatingResult,
          backgroundValues = flowSOM.res$metaclustering)
          
}
\seealso{
\code{\link{PlotStars}}, \code{\link{PlotVariable}},
\code{\link{PlotFlowSOM}}, \code{\link{PlotLabels}}, 
\code{\link{PlotNumbers}}, \code{\link{PlotMarker}},
 \code{\link{QueryStarPlot}}, \code{\link{PlotSD}}
}
