% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/5_plotFunctions.R
\name{PlotOutliers}
\alias{PlotOutliers}
\title{PlotOutliers}
\usage{
PlotOutliers(fsom, outlierReport)
}
\arguments{
\item{fsom}{FlowSOM object.}

\item{outlierReport}{Outlier overview as generated by TestOutliers()}
}
\value{
Plot
}
\description{
Visual overview of outliers
}
\examples{

# Identify the files
fcs <- flowCore::read.FCS(system.file("extdata", "68983.fcs", 
                                      package = "FlowSOM"))
# Build a FlowSOM object
flowSOM.res <- FlowSOM(fcs, 
                       scale = TRUE,
                       compensate = TRUE, 
                       transform = TRUE,
                       toTransform = 8:18, 
                       colsToUse = c(9, 12, 14:18),
                       nClus = 10,
                       seed = 1)
outlierReport <- TestOutliers(flowSOM.res)
p <- PlotOutliers(flowSOM.res, outlierReport)                       

}
