% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/5_plotFunctions.R
\name{PlotNumbers}
\alias{PlotNumbers}
\title{PlotNumbers}
\usage{
PlotNumbers(fsom, level = "clusters", maxNodeSize = 0, ...)
}
\arguments{
\item{fsom}{FlowSOM object}

\item{level}{Character string, should be either "clusters" or 
"metaclusters". Can be abbreviated.}

\item{maxNodeSize}{Determines the maximum node size. Default is 0. 
See \code{\link{PlotFlowSOM}} for more options.}

\item{...}{Additional arguments to pass to \code{\link{PlotLabels}} 
and to \code{\link{PlotFlowSOM}}}
}
\value{
Nothing is returned. A plot is drawn in which each node is 
labeled by its cluster id.
}
\description{
Plot cluster ids for each cluster
}
\details{
Plot FlowSOM grid or tree, with in each node the cluster id.
}
\examples{
# Read from file, build self-organizing map and minimal spanning tree
fileName <- system.file("extdata", "68983.fcs", package = "FlowSOM")
ff <- flowCore::read.FCS(fileName)
ff <- flowCore::compensate(ff, flowCore::keyword(ff)[["SPILL"]])
ff <- flowCore::transform(ff, flowCore::estimateLogicle(ff,
                                               flowCore::colnames(ff)[8:18]))
flowSOM.res <- FlowSOM(ff,
                       scale = TRUE,
                       colsToUse = c(9, 12, 14:18),
                       nClus = 10,
                       seed = 1)

# Plot the node IDs
PlotNumbers(flowSOM.res)
PlotNumbers(flowSOM.res, "metaclusters")

PlotNumbers(flowSOM.res,
            view = "grid")

PlotNumbers(flowSOM.res,
            maxNodeSize = 1,
            equalNodeSize = TRUE)

}
\seealso{
\code{\link{PlotStars}}, \code{\link{PlotVariable}},
\code{\link{PlotFlowSOM}}, \code{\link{PlotLabels}}, 
\code{\link{PlotMarker}}, \code{\link{PlotPies}},
 \code{\link{QueryStarPlot}}, \code{\link{PlotSD}}
}
