% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/5_plotFunctions.R
\name{PlotFlowSOM}
\alias{PlotFlowSOM}
\title{PlotFlowSOM}
\usage{
PlotFlowSOM(
  fsom,
  view = "MST",
  nodeSizes = fsom$map$pctgs,
  maxNodeSize = 1,
  refNodeSize = max(nodeSizes),
  equalNodeSize = FALSE,
  backgroundValues = NULL,
  backgroundColors = NULL,
  backgroundLim = NULL,
  title = NULL
)
}
\arguments{
\item{fsom}{FlowSOM object, as created by \code{\link{FlowSOM}}}

\item{view}{Preferred view, options: "MST", "grid" or "matrix" 
with a matrix/dataframe consisting of coordinates. 
Default = "MST"}

\item{nodeSizes}{A vector containing node sizes. These will 
automatically be scaled between 0 and maxNodeSize 
and transformed with a sqrt. Default = fsom$MST$sizes}

\item{maxNodeSize}{Determines the maximum node size. Default is 1.}

\item{refNodeSize}{Reference for node size against which the nodeSizes 
will be scaled. Default = max(nodeSizes)}

\item{equalNodeSize}{If \code{TRUE}, the nodes will be equal to 
maxNodeSize. If \code{FALSE} (default), the nodes  
will be scaled to the number of cells in each 
cluster}

\item{backgroundValues}{Values to be used for background coloring, either
numerical values or something that can be made into
a factor (e.g. a clustering)}

\item{backgroundColors}{Color palette to be used for the background coloring.
Can be either a function or an array specifying
colors.}

\item{backgroundLim}{Only used when backgroundValues are numerical. 
Defaults to min and max of the backgroundValues.}

\item{title}{Title of the plot}
}
\value{
A ggplot object with the base layer of a FlowSOM plot
}
\description{
Base layer to plot a FlowSOM result
}
\details{
Base layer of the FlowSOM plot, where you can choose layout (MST, grid or 
coordinates of your own choosing), background colors and node size. Can
then be extended by e.g. \code{\link{AddStars}}, \code{\link{AddLabels}},
\code{\link{AddPies}}, ...
}
\examples{
# Locate file on file system
fcs_file <- system.file("extdata", "68983.fcs", package = "FlowSOM")

# Build FlowSOM model
flowSOM.res <- FlowSOM(fcs_file, 
                       scale = TRUE,
                       compensate = TRUE, 
                       transform = TRUE,
                       toTransform = 8:18, 
                       colsToUse = c(9, 12, 14:18),
                       nClus = 10,
                       seed = 1)
                       
# Plot with background coloring
PlotFlowSOM(flowSOM.res,
            backgroundValues = flowSOM.res$metaclustering) \%>\% 
            AddLabels(seq(100))


}
\seealso{
\code{\link{PlotStars}}, \code{\link{PlotVariable}},
\code{\link{PlotMarker}}, \code{\link{PlotLabels}}, 
\code{\link{PlotNumbers}}, \code{\link{PlotPies}}, 
\code{\link{QueryStarPlot}}, \code{\link{PlotSD}}
}
