% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/5_plotFunctions.R
\name{Plot2DScatters}
\alias{Plot2DScatters}
\title{Plot2DScatters}
\usage{
Plot2DScatters(
  fsom,
  channelpairs,
  clusters = NULL,
  metaclusters = NULL,
  maxBgPoints = 3000,
  sizeBgPoints = 0.5,
  maxPoints = 1000,
  sizePoints = 0.5,
  xLim = NULL,
  yLim = NULL,
  xyLabels = c("marker"),
  density = TRUE,
  centers = TRUE,
  colors = NULL,
  plotFile = "2DScatterPlots.png"
)
}
\arguments{
\item{fsom}{FlowSOM object, as created by \code{\link{FlowSOM}}}

\item{channelpairs}{List in which each element is a pair of channel
or marker names}

\item{clusters}{Vector or list (to combine multiple clusters in one
plot) with indices of clusters of interest}

\item{metaclusters}{Vector or list (to combine multiple metaclusters in 
one plot) with indices of metaclusters of interest}

\item{maxBgPoints}{Maximum number of background cells to plot}

\item{sizeBgPoints}{Size of the background cells}

\item{maxPoints}{Maximum number of (meta)cluster cells to plot}

\item{sizePoints}{Size of the (meta)cluster cells}

\item{xLim}{Optional vector of a lower and upper limit of the x-axis}

\item{yLim}{Optional vector of a lower and upper limit of the y-axis}

\item{xyLabels}{Determines the label of the x- and y-axis. Can be 
"marker" and\\or "channel" or abbrevations.
 Default = "marker".}

\item{density}{Default is \code{TRUE} to color the (meta)cluster 
points according to density. Set to \code{FALSE} to 
use a plain color}

\item{centers}{Default is \code{TRUE} to show the cluster centers}

\item{colors}{Colors for all the cells in the selected nodes 
(ordered list). First the clusters are colored, 
then the metaclusters. If \code{NULL}, the default 
ggplot colors, indexed by metacluster number, are used.}

\item{plotFile}{If a filepath for a png is given (default = 
2DScatterPlots.png), the plots will be plotted in 
the corresponding png file. If \code{NULL}, a list 
of ggplot objects will be returned}
}
\value{
If \code{plot} is \code{TRUE}, nothing is returned and a plot is 
        drawn in which background cells are plotted in gray and the cells of
        the selected nodes in color. If \code{plot} is \code{FALSE}, a ggplot
         objects list is returned.
}
\description{
Function to draw 2D scatter plots of FlowSOM (meta)clusters
}
\details{
Plot multiple 2D scatter plots in a png file. A subset of fsom$data is 
plotted in gray, and those of the selected clusters and metaclusters are 
plotted in color.
}
\examples{
# Identify the files
fcs <- flowCore::read.FCS(system.file("extdata", "68983.fcs", 
                                      package = "FlowSOM"))

# Build a FlowSOM object
flowSOM.res <- FlowSOM(fcs, 
                       scale = TRUE,
                       compensate = TRUE, 
                       transform = TRUE,
                       toTransform = 8:18, 
                       colsToUse = c(9, 12, 14:18),
                       nClus = 10,
                       seed = 1)

# Make the 2D scatter plots of the clusters and metaclusters of interest
Plot2DScatters(fsom = flowSOM.res,
               channelpairs = list(c("PE-Cy7-A", "PE-Cy5-A"),
                                   c("PE-Texas Red-A", "Pacific Blue-A")),
               clusters = c(1, 48, 49, 82, 95),
               metaclusters = list(c(1, 4), 9),
               density = FALSE)
               
Plot2DScatters(fsom = flowSOM.res,
               channelpairs = list(c("PE-Texas Red-A", "Pacific Blue-A")),
               metaclusters = list(c(1, 4)),
               density = FALSE,
               colors = list(c("red", "green")))

}
