% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3_buildMST.R
\name{NewData}
\alias{NewData}
\title{NewData}
\usage{
NewData(
  fsom,
  input,
  madAllowed = 4,
  compensate = NULL,
  spillover = NULL,
  transform = NULL,
  toTransform = NULL,
  transformFunction = NULL,
  transformList = NULL,
  scale = NULL,
  scaled.center = NULL,
  scaled.scale = NULL,
  silent = FALSE
)
}
\arguments{
\item{fsom}{FlowSOM object}

\item{input}{A flowFrame, a flowSet or an array of paths to files 
or directories}

\item{madAllowed}{A warning is generated if the distance of the new
data points to their closest cluster center is too
big. This is computed based on the typical distance
of the points from the original dataset assigned to
that cluster, the threshold being set to
median + madAllowed * MAD. Default is 4.}

\item{compensate}{logical, does the data need to be compensated. If NULL,
the same value as in the original FlowSOM call will be 
used.}

\item{spillover}{spillover matrix to compensate with. If NULL,
the same value as in the original FlowSOM call will be 
used.}

\item{transform}{logical, does the data need to be transformed. If NULL,
the same value as in the original FlowSOM call will be 
used.}

\item{toTransform}{column names or indices that need to be transformed.
If NULL,  the same value as in the original FlowSOM 
call will be used.}

\item{transformFunction}{If NULL, the same value as in the original FlowSOM 
call will be used.}

\item{transformList}{If NULL, the same value as in the original FlowSOM 
call will be used.}

\item{scale}{Logical, does the data needs to be rescaled. If NULL, 
the same value as in the original FlowSOM call will be 
used.}

\item{scaled.center}{See \code{\link{scale}}. If NULL, the same value as in 
the original FlowSOM call will be used.}

\item{scaled.scale}{See \code{\link{scale}}. If NULL, the same value as in 
the original FlowSOM call will be used.}

\item{silent}{Logical. If \code{TRUE}, print progress messages. 
Default = \code{FALSE}.}
}
\value{
A new FlowSOM object
}
\description{
Map new data to a FlowSOM grid
}
\details{
New data is mapped to an existing FlowSOM object. The input is similar to the
\code{\link{ReadInput}} function.
A new FlowSOM object is created, with the same grid, but a new
mapping, node sizes and mean values. The same preprocessing steps
(compensation, transformation and scaling) will happen to this file as was 
specified in the original FlowSOM call. The scaling parameters from the 
original grid will be used.
}
\examples{
 # Build FlowSom result
 fileName <- system.file("extdata", "68983.fcs", package = "FlowSOM")
 ff <- flowCore::read.FCS(fileName)
 ff <- flowCore::compensate(ff, flowCore::keyword(ff)[["SPILL"]])
 ff <- flowCore::transform(ff,
         flowCore::transformList(colnames(flowCore::keyword(ff)[["SPILL"]]),
                                flowCore::logicleTransform()))
   flowSOM.res <- FlowSOM(ff[1:1000, ], 
                          scale = TRUE, 
                          colsToUse = c(9, 12, 14:18),
                          nClus = 10)
   
   # Map new data
   fSOM2 <- NewData(flowSOM.res, ff[1001:2000, ])

}
\seealso{
\code{\link{FlowSOMSubset}} if you want to get a subset of the
         current data instead of a new dataset
}
