% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/4_metaClustering.R
\name{MetaClustering}
\alias{MetaClustering}
\title{MetaClustering}
\usage{
MetaClustering(data, method, max = 20, seed = NULL, ...)
}
\arguments{
\item{data}{Matrix containing the data to cluster}

\item{method}{Clustering method to use}

\item{max}{Maximum number of clusters to try out}

\item{seed}{Seed to pass on to given clustering method}

\item{...}{Extra parameters to pass along}
}
\value{
Numeric array indicating cluster for each datapoint
}
\description{
Cluster data with automatic number of cluster determination for 
several algorithms
}
\examples{
   # Read from file, build self-organizing map and minimal spanning tree
   fileName <- system.file("extdata", "68983.fcs", package = "FlowSOM")
   flowSOM.res <- ReadInput(fileName, compensate = TRUE,transform = TRUE,
                            scale = TRUE)
   flowSOM.res <- BuildSOM(flowSOM.res,colsToUse = c(9, 12, 14:18))
   flowSOM.res <- BuildMST(flowSOM.res)
   
   # Apply metaclustering
   metacl <- MetaClustering(flowSOM.res$map$codes,
                            "metaClustering_consensus",
                            max = 10)
   
   # Get metaclustering per cell
   flowSOM.clustering <- metacl[flowSOM.res$map$mapping[, 1]]    

}
\seealso{
\code{\link{metaClustering_consensus}}
}
