% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2_buildSOM.R
\name{GetMetaclusters}
\alias{GetMetaclusters}
\title{Get metacluster label for all individual cells}
\usage{
GetMetaclusters(fsom, meta = NULL)
}
\arguments{
\item{fsom}{FlowSOM object as generated by the FlowSOM function
or the BuildSOM function}

\item{meta}{Metacluster label for each FlowSOM cluster. If this
is NULL, the fsom argument should be as generated by
the FlowSOM function, and fsom$metaclustering will
be used.}
}
\value{
vector label for every cell
}
\description{
Get metacluster label for all individual cells
}
\examples{
fileName <- system.file("extdata", "68983.fcs", package = "FlowSOM")
flowSOM.res <- FlowSOM(fileName, compensate = TRUE, transform = TRUE,
                      scale = TRUE, colsToUse = c(9, 12, 14:18), nClus = 10)
metacluster_labels <- GetMetaclusters(flowSOM.res)
metacluster_labels <- GetMetaclusters(flowSOM.res,
                                      meta = flowSOM.res$metaclustering)

}
