% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_FlowSOM.R
\name{AggregateFlowFrames}
\alias{AggregateFlowFrames}
\title{Aggregate multiple FCS files together}
\usage{
AggregateFlowFrames(
  fileNames,
  cTotal,
  channels = NULL,
  writeOutput = FALSE,
  outputFile = "aggregate.fcs",
  keepOrder = FALSE,
  silent = FALSE,
  sampleWithReplacement = FALSE,
  ...
)
}
\arguments{
\item{fileNames}{Character vector containing full paths to the FCS files
or a flowSet to aggregate}

\item{cTotal}{Total number of cells to write to the output file}

\item{channels}{Channels/markers to keep in the aggregate. Default NULL 
takes all channels of the first file.}

\item{writeOutput}{Whether to write the resulting flowFrame to a file. 
Default FALSE}

\item{outputFile}{Full path to output file. Default "aggregate.fcs"}

\item{keepOrder}{If TRUE, the random subsample will be ordered in the same
way as they were originally ordered in the file. Default =
FALSE.}

\item{silent}{If FALSE, prints an update every time it starts processing a
new file. Default = FALSE.}

\item{sampleWithReplacement}{If TRUE and more cells per file are requested
than actually present, all cells will be included
plus additional resampling. Otherwise, at most 
all cells will be included once. Default = FALSE.}

\item{...}{Additional arguments to pass to read.FCS}
}
\value{
This function does not return anything, but will write a file with
        about \code{cTotal} cells to \code{outputFile}
}
\description{
Aggregate multiple FCS files to analyze them simultaneously. 
A new FCS file is written, which contains about \code{cTotal} cells,
with \code{ceiling(cTotal/nFiles)} cells from each file. Two new columns
are added: a column indicating the original file by index, and a noisy 
version of this for better plotting opportunities (index plus or minus a 
value between 0 and 0.1).
}
\examples{
# Define filename
fileName <- system.file("extdata", "68983.fcs", package = "FlowSOM")
# This example will sample 2 times 500 cells.
ff_new <- AggregateFlowFrames(c(fileName, fileName), 1000)

}
\seealso{
\code{\link{ceiling}}
}
