% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integrateInfo.R
\name{integrate_replicates}
\alias{integrate_replicates}
\title{integrate_replicates}
\usage{
integrate_replicates(
  mt,
  colData,
  fun = NULL,
  type = c("value", "rank", "rank_zscore", "pvalue")
)
}
\arguments{
\item{mt}{value matrix}

\item{colData}{a data.frame with a single column named with "type". Rows of colData
correspond to columns of mt.}

\item{fun}{the function you want to use. If set NULL, program will decide integrate
method according to your 'type' parameter.}

\item{type}{one of 'value', 'rank', 'rank_zscore', pvalue'.
value will use mean to integrate replicates,
rank will use product, rank_zscore will use Stouffer's method
and pvalue will use CCT(Cauchy distribution)}
}
\value{
matrix
}
\description{
integrate value from replicates
}
\examples{
mt <- matrix(runif(100, 0, 1), nrow = 10)
colnames(mt) <- paste0(paste0("type", 1:5), "_", rep(1:2, 5))
rownames(mt) <- paste0("TF", 1:10)

colData <- data.frame(
    type = gsub("_[0-9]", "", colnames(mt)),
    row.names = colnames(mt)
)


integrate_replicates(mt, colData, type = "value")
}
