% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_influential_TF.R
\name{findIT_regionRP}
\alias{findIT_regionRP}
\title{findI(nfluential)T(F)_regionRP}
\usage{
findIT_regionRP(
  regionRP,
  Txdb,
  TF_GR_database,
  input_genes,
  background_genes = NULL,
  background_number = 3000,
  verbose = TRUE
)
}
\arguments{
\item{regionRP}{the MultiAssayExperiment object from calcRP_region}

\item{Txdb}{Txdb}

\item{TF_GR_database}{TF peak GRange with a column named TF_id representing you TF name}

\item{input_genes}{a character vector which represent genes set
which you want to find influential TF for}

\item{background_genes}{a character vector which represent background genes set.
If you do not assign background gene , program will sample
background_number genes as background genes from all gene sets.}

\item{background_number}{background genes number}

\item{verbose}{whether you want to report detailed running message}
}
\value{
a MultiAssayExperiment object containg detailed TF-percent and TF-pvalue
}
\description{
find Influential TF of your input gene set based on regulatory potential data and TF ChIP-Seq or
motif data
}
\examples{
if (require(TxDb.Athaliana.BioMart.plantsmart28)) {
    data("ATAC_normCount")
    data("test_geneSet")
    Txdb <- TxDb.Athaliana.BioMart.plantsmart28
    seqlevels(Txdb) <- paste0("Chr", c(1:5, "M", "C"))

    peak_path <- system.file("extdata", "ATAC.bed.gz", package = "FindIT2")
    peak_GR <- loadPeakFile(peak_path)

    ChIP_peak_path <- system.file("extdata", "ChIP.bed.gz", package = "FindIT2")
    ChIP_peak_GR <- loadPeakFile(ChIP_peak_path)
    ChIP_peak_GR$TF_id <- "AT1G28300"

    mmAnno <- mm_geneScan(peak_GR, Txdb)

    regionRP <- calcRP_region(
        mmAnno = mmAnno,
        peakScoreMt = ATAC_normCount,
        Txdb = Txdb,
        Chrs_included = "Chr5"
    )

    set.seed(20160806)
    result_findIT_regionRP <- findIT_regionRP(
        regionRP = regionRP,
        Txdb = Txdb,
        TF_GR_database = ChIP_peak_GR,
        input_genes = test_geneSet,
        background_number = 3000
    )

}
}
