% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_influential_TF.R
\name{findIT_TTPair}
\alias{findIT_TTPair}
\title{findI(nfluential)T(F)_T(F)T(arget)Pair}
\usage{
findIT_TTPair(
  input_genes,
  TF_target_database,
  gene_background = NULL,
  TFHit_min = 5,
  TFHit_max = 10000
)
}
\arguments{
\item{input_genes}{a character vector which represent genes set
which you want to find influential TF for}

\item{TF_target_database}{TF_target pair data with two column named TF_id and
target_gene}

\item{gene_background}{a character vector represent your bakcaground gene.
If you do not assign background gene, program will consider
all target gene as background}

\item{TFHit_min}{minimal size of target gene regulated by TF}

\item{TFHit_max}{maximal size of target gene regulated by TF}
}
\value{
data.frame
}
\description{
find influential TF of your input gene set based on public TF-Target data
}
\examples{
data("TF_target_database")
data("test_geneSet")

result_findIT_TTPair <- findIT_TTPair(
    input_genes = test_geneSet,
    TF_target_database = TF_target_database
)
}
