% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plotVarianceExplained}
\alias{plotVarianceExplained}
\title{plotVarianceExplained}
\usage{
plotVarianceExplained(res)
}
\arguments{
\item{res}{result \code{SummarizedExperiment} from \code{FeatSeek} function}
}
\value{
returns plot of variance explained vs number of features
}
\description{
plot variance explained from 1 to max_features in res
}
\examples{
# run FeatSeek to select the top 20 features
data <-  array(rnorm(100*30), dim=c(30,100),
            dimnames = list(paste("feature", seq_len(30)), NULL))
conds <- rep(seq_len(50), 2)
res <- FeatSeek(data, conds, max_features=20)

# res stores the 20 selected features ranked by their replicate 
# reproducibility
plotVarianceExplained(res)

}
