% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unique_filter.R
\name{unique_filter}
\alias{unique_filter}
\title{Remove duplicated sequences in a FASTQ file}
\usage{
unique_filter(input)
}
\arguments{
\item{input}{\code{\link[ShortRead:ShortReadQ-class]{ShortReadQ}} object}
}
\value{
Filtered \code{\link[ShortRead:ShortReadQ-class]{ShortReadQ}} object
}
\description{
This program is a wrapper to  
\code{\link[ShortRead:srFilter]{occurrenceFilter}}. 
It removes the duplicated sequences of a FASTQ file.
}
\examples{

require('Biostrings')
require('ShortRead')

set.seed(10)
s <- random_seq(10, 10)
s <- sample(s, 30, replace = TRUE)
q <- random_qual(30, 10)
n <- seq_names(30)

my_read <- ShortReadQ(sread = s, quality = q, id = n)

# check presence of duplicates
isUnique(as.character(sread(my_read)))

# apply the filter
filtered <- unique_filter(my_read)

isUnique(as.character(sread(filtered)))
}
\author{
Leandro Roser \email{learoser@gmail.com}
}
