% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fixed_filter.R
\name{fixed_filter}
\alias{fixed_filter}
\title{Remove a fixed number of bases of a ShortReadQ object from 3' or 5'}
\usage{
fixed_filter(input, trim3 = NA, trim5 = NA)
}
\arguments{
\item{input}{\code{\link[ShortRead:ShortReadQ-class]{ShortReadQ}} object}

\item{trim3}{Number of bases to remove from 3'}

\item{trim5}{Number of bases to remove from 5'}
}
\value{
Filtered \code{\link[ShortRead:ShortReadQ-class]{ShortReadQ}} 
object
}
\description{
The program removes a given number of bases from the 3' or 5'
regions of the sequences contained in a ShortReadQ object
}
\examples{
require('Biostrings')
require('ShortRead')

# create 6 sequences of width 20
 
set.seed(10)
input <- random_seq(6, 20)

# create qualities of width 20 

set.seed(10)
input_q <- random_qual(c(30,40), slength = 6, swidth = 20, 
encod = 'Sanger')


# create names
input_names <- seq_names(6)

# create ShortReadQ object
my_read <- ShortReadQ(sread = input, quality = input_q, id = input_names)

# apply the filter 
filtered3 <- fixed_filter(my_read, trim5 = 5)

filtered5 <- fixed_filter(my_read, trim3 = 5)

filtered3and5 <- fixed_filter(my_read, trim3 = 10, trim5 = 5)

# look at the trimmed sequences
sread(filtered3)
sread(filtered5)
sread(filtered3and5)

}
\author{
Leandro Roser \email{learoser@gmail.com}
}
