% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_decay.R
\name{weight_transcripts}
\alias{weight_transcripts}
\title{Weight transcripts by read counts}
\usage{
weight_transcripts(
  counts,
  type = "sigmoid",
  min_counts = 1000,
  inflection_idx = 10,
  inflection_max = 1000,
  steepness = 5
)
}
\arguments{
\item{counts}{numeric vector of read counts}

\item{type}{string, one of 'counts', 'sigmoid', or 'equal'}

\item{min_counts}{numeric, the threshold for the 'equal' type}

\item{inflection_idx}{numeric, the index of the read counts to determine the
inflection point for the sigmoid function. The default is 10, i.e. the 10th
highest read count will be the inflection point.}

\item{inflection_max}{numeric, the maximum value for the inflection point.
If the inflection point according to the inflection_idx is higher than this
value, the inflection point will be set to this value instead.}

\item{steepness}{numeric, the steepness of the sigmoid function}
}
\value{
numeric vector of weights
}
\description{
Given a vector of read counts, return a vector of weights.
The weights could be either the read counts themselves (\code{type = 'counts'}),
a binary vector of 0s and 1s where 1s are assigned to transcripts with read
counts above a threshold (\code{type = 'equal', min_counts = 1000}), or a
sigmoid function of the read counts (\code{type = 'sigmoid'}). The sigmoid
function is defined as \code{1 / (1 + exp(-steepness/inflection * (x - inflection)))}.
}
\examples{
weight_transcripts(1:2000)
par(mfrow = c(2, 2))
plot(
  1:2000, weight_transcripts(1:2000, type = 'sigmoid'),
  type = 'l', xlab = 'Read counts', ylab = 'Sigmoid weight'
)
plot(
  1:2000, weight_transcripts(1:2000, type = 'counts'),
  type = 'l', xlab = 'Read counts', ylab = 'Weight by counts'
)
plot(
  1:2000, weight_transcripts(1:2000, type = 'equal'),
  type = 'l', xlab = 'Read counts', ylab = 'Equal weights'
)

}
