% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sc_mutations.R
\name{sc_plot_genotype}
\alias{sc_plot_genotype}
\title{Plot genotype of single-cell data}
\usage{
sc_plot_genotype(
  sce,
  genotype_tb,
  reduced_dim = "UMAP",
  na_cell_col = "grey",
  na_cell_size = 0.1,
  na_cell_alpha = 0.1,
  ...
)
}
\arguments{
\item{sce}{SingleCellExperiment: the single-cell experiment object with reduced dimensions.}

\item{genotype_tb}{tibble: the genotype table, output from \code{sc_genotype}.}

\item{reduced_dim}{character(1): the name of the reduced dimension to use for plotting.}

\item{na_cell_col}{character(1): the color of the cells with no genotype.}

\item{na_cell_size}{numeric(1): the size of the cells with no genotype.}

\item{na_cell_alpha}{numeric(1): the alpha of the cells with no genotype.}

\item{...}{additional arguments passed to \code{geom_point} for cells with genotype.}
}
\value{
A ggplot2 object with the genotype plotted on the reduced dimension.
}
\description{
Plot the genotype of single-cell data on a reduced dimension plot (e.g. UMAP).
}
\examples{
ppl <- example_pipeline("SingleCellPipeline") |>
  run_FLAMES()
sce <- experiment(ppl) |>
 scuttle::logNormCounts() |>
 scater::runPCA() |>
 scater::runUMAP()
snps_tb <- sc_mutations(
  bam_path = ppl@genome_bam,
  seqnames = "chr14",
  positions = 2714
)
genotype_tb <- sc_genotype(
  snps_tb, ref = "C", alt = "T", seqname = "chr14", pos = 2714,
  alt_min_count = 2, alt_min_pct = 0.5, ref_min_count = 1, ref_min_pct = 1
)
sc_plot_genotype(
  sce, genotype_tb, na_cell_col = "black",
  na_cell_size = 0.5, na_cell_alpha = 0.7,
  size = 2
)
}
