% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_isoform.R
\name{get_GRangesList}
\alias{get_GRangesList}
\title{Parse FLAMES' GFF output}
\usage{
get_GRangesList(
  file,
  feature.type = c("exon", "utr"),
  drop.cols = c("type", "exon_number", "exon_id", "level", "Parent")
)
}
\arguments{
\item{file}{the GFF file to parse}

\item{feature.type}{The type of features to extract from the GFF file. Default is \code{c("exon", "utr")}.}

\item{drop.cols}{Columns to drop from the metadata. Default is \code{c("type", "exon_number", "exon_id", "level")},
which are exon-specific metadata that may not be relevant when keeping just the first row (exon).}
}
\value{
A list containing a \code{GRangesList} of isoforms and a \code{DataFrame}, which have
the same number of rows as the number of unique transcript IDs in the GFF file.
}
\description{
Parse FLAMES' GFF ouputs into a Genomic Ranges List
}
\keyword{internal}
