% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_decay.R
\name{filter_coverage}
\alias{filter_coverage}
\title{Filter transcript coverage}
\usage{
filter_coverage(x, filter_fn = convolution_filter)
}
\arguments{
\item{x}{The tibble returned by \code{\link{get_coverage}}, or a BAM file path, or
a GAlignments object.}

\item{filter_fn}{The filter function to apply to the coverage values. The function
should take a numeric vector of coverage values and return a logical value (TRUE if
the transcript passes the filter, FALSE otherwise). The default filter function is
\code{\link{convolution_filter}}, which filters out transcripts with sharp drops /
rises in coverage.}
}
\value{
a tibble of the transcript information and coverages, with transcipts that
pass the filter
}
\description{
Filter the transcript coverage by applying a filter function to the
coverage values.
}
\examples{
ppl <- example_pipeline("BulkPipeline")
steps(ppl)["isoform_identification"] <- FALSE
ppl <- run_step(ppl, "read_realignment")
x <- get_coverage(ppl@transcriptome_bam[[1]])
nrow(x)
filter_coverage(x) |>
  nrow()
}
