% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_decay.R
\name{filter_annotation}
\alias{filter_annotation}
\title{filter annotation for plotting coverages}
\usage{
filter_annotation(annotation, keep = "tss_differ")
}
\arguments{
\item{annotation}{path to the GTF annotation file, or the parsed GenomicRanges
object with a valid \code{transcript_id} column, and each Range representing
a transcript.}

\item{keep}{string, one of 'tss_differ' (only keep isoforms that all differ
by the transcription start site position), 'tes_differ' (only keep those that
differ by the transcription end site position), 'both' (only keep those that
differ by both the start and end site), or 'single_transcripts' (only keep
genes that contains a sinlge transcript).}
}
\value{
GenomicRanges of the filtered isoforms
}
\description{
Removes isoform annotations that could produce ambigious reads, such as isoforms
that only differ by the 5' / 3' end. This could be useful for plotting average
coverage plots.
}
\examples{
filtered_annotation <- filter_annotation(
  system.file("extdata", "rps24.gtf.gz", package = 'FLAMES'), keep = 'tes_differ')
filtered_annotation

}
