% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial.R
\name{create_spe}
\alias{create_spe}
\title{Create a SpatialExperiment object}
\usage{
create_spe(
  sce,
  spatial_barcode_file,
  mannual_align_json,
  image,
  tissue_positions_file
)
}
\arguments{
\item{sce}{The SingleCellExperiment object obtained from running the \code{\link{sc_long_pipeline}} function.}

\item{spatial_barcode_file}{The path to the spatial barcode file, e.g. \code{"spaceranger-2.1.1/lib/python/cellranger/barcodes/visium-v2_coordinates.txt"}.}

\item{mannual_align_json}{The path to the mannual alignment json file.}

\item{image}{'DataFrame' containing the image data. See \code{?SpatialExperiment::readImgData} and \code{?SpatialExperiment::SpatialExperiment}.}

\item{tissue_positions_file}{The path to Visium positions file, e.g. \code{"spaceranger-2.1.1/lib/python/cellranger/barcodes/visium-v2_tissue_positions_list.csv"}.}
}
\value{
A SpatialExperiment object.
}
\description{
This function creates a SpatialExperiment object from a SingleCellExperiment object and a spatial barcode file.
}
