// #include <vector>
// #include <string>
// #include <unordered_map>
// #include <set>
// #include <iostream>
// #include <testthat.h>
// #include <Rcpp.h>

// #include "../classes/StartEndPair.h"
// #include "../classes/junctions.h"
// #include "../classes/types.h"
// #include "test_utilities.h"

// static std::unordered_map<std::string, transcriptvector> 
// gene_to_transcript = {
//     {"SIRV5", {"SIRV508", "SIRV509", "SIRV502", "SIRV503", "SIRV501", "SIRV506", "SIRV507", "SIRV504", "SIRV505", "SIRV512", "SIRV510"}},
//     {"SIRV4", {"SIRV403", "SIRV410", "SIRV406", "SIRV405", "SIRV404", "SIRV409", "SIRV408"}},
//     {"SIRV7", {"SIRV708", "SIRV701", "SIRV702", "SIRV703", "SIRV704", "SIRV706"}},
//     {"SIRV6", {"SIRV618", "SIRV617", "SIRV601", "SIRV616", "SIRV603", "SIRV602", "SIRV605", "SIRV604", "SIRV607", "SIRV606", "SIRV609", "SIRV608", "SIRV614", "SIRV615", "SIRV612", "SIRV613", "SIRV610", "SIRV611"}},
//     {"SIRV1", {"SIRV108", "SIRV109", "SIRV106", "SIRV107", "SIRV105", "SIRV102", "SIRV103", "SIRV101"}},
//     {"SIRV3", {"SIRV310", "SIRV311", "SIRV308", "SIRV309", "SIRV304", "SIRV305", "SIRV306", "SIRV307", "SIRV301", "SIRV302", "SIRV303"}},
//     {"SIRV2", {"SIRV205", "SIRV204", "SIRV206", "SIRV201", "SIRV203", "SIRV202"}}
// };


// // gene_to_transcript = {
// //     "SIRV5": ["SIRV508", "SIRV509", "SIRV502", "SIRV503", "SIRV501", "SIRV506", "SIRV507", "SIRV504", "SIRV505", "SIRV512", "SIRV510"],
// // 	"SIRV4": ["SIRV403", "SIRV410", "SIRV406", "SIRV405", "SIRV404", "SIRV409", "SIRV408"],
// // 	"SIRV7": ["SIRV708", "SIRV701", "SIRV702", "SIRV703", "SIRV704", "SIRV706"],
// // 	"SIRV6": ["SIRV618", "SIRV617", "SIRV601", "SIRV616", "SIRV603", "SIRV602", "SIRV605", "SIRV604", "SIRV607", "SIRV606", "SIRV609", "SIRV608", "SIRV614", "SIRV615", "SIRV612", "SIRV613", "SIRV610", "SIRV611"],
// // 	"SIRV1": ["SIRV108", "SIRV109", "SIRV106", "SIRV107", "SIRV105", "SIRV102", "SIRV103", "SIRV101"],
// // 	"SIRV3": ["SIRV310", "SIRV311", "SIRV308", "SIRV309", "SIRV304", "SIRV305", "SIRV306", "SIRV307", "SIRV301", "SIRV302", "SIRV303"],
// // 	"SIRV2": ["SIRV205", "SIRV204", "SIRV206", "SIRV201", "SIRV203", "SIRV202"]
// // }

// static std::unordered_map<std::string, std::vector<exon>> 
// transcript_to_exon = {
//     {"SIRV410", {{1455, 1885}, {2251, 2771}}},
//     {"SIRV706", {{56031, 56097}, {70883, 70987}, {78841, 78963}, {114680, 114988}, {147608, 147957}}},
//     {"SIRV618", {{2358, 2547}}},
//     {"SIRV511", {{1008, 1143}, {1987, 2398}}},
//     {"SIRV510", {{1028, 1149}, {1987, 2033}, {2119, 2156}, {2270, 2315}, {3298, 3404}, {3483, 3643}, {5380, 5450}, {5543, 5626}, {6111, 6169}, {6327, 6452}, {6826, 6957}, {7144, 7307}, {7681, 7762}, {7870, 8016}, {8277, 8381}, {8454, 8585}, {10858, 10991}, {11133, 11867}}},
//     {"SIRV512", {{2177, 2406}}},
//     {"SIRV601", {{1000, 1186}, {1468, 1534}, {1640, 1735}, {2470, 2620}, {2740, 2828}, {3106, 3164}, {10724, 10818}, {11031, 11108}, {11205, 11826}}},
//     {"SIRV616", {{2285, 2620}, {2740, 2814}, {3106, 3164}, {10724, 10788}}},
//     {"SIRV603", {{8999, 10968}}},
//     {"SIRV509", {{8315, 8381}, {8454, 8585}, {10858, 10991}, {11311, 11866}}},
//     {"SIRV605", {{1130, 1186}, {1468, 1534}, {1640, 1735}, {1845, 2026}, {2470, 2620}, {2740, 2828}, {3106, 3164}, {10724, 10818}, {11031, 11331}}},
//     {"SIRV604", {{1087, 1186}, {1468, 1534}, {1640, 1735}, {1845, 2026}, {2470, 2620}, {2740, 2828}, {3106, 3164}, {10724, 10818}, {11034, 11108}, {11205, 11837}}},
//     {"SIRV607", {{1130, 1186}, {1468, 1735}, {1845, 2026}, {2470, 2540}}},
//     {"SIRV606", {{2285, 2620}, {2740, 2828}, {3106, 3164}, {10724, 10788}}},
//     {"SIRV609", {{1137, 1186}, {1468, 1534}, {1640, 1735}, {1845, 2120}}},
//     {"SIRV608", {{3023, 3164}, {10724, 10818}, {11031, 11108}, {11205, 11270}}},
//     {"SIRV702", {{1000, 2675}, {2993, 3111}, {4095, 4179}, {4725, 4810}, {43028, 43077}, {114680, 114916}}},
//     {"SIRV703", {{1000, 2675}, {2993, 3111}, {3809, 3896}, {114680, 114988}, {147608, 147918}}},
//     {"SIRV704", {{55849, 56097}, {78841, 78963}, {114680, 114738}}},
//     {"SIRV614", {{2516, 2620}, {2740, 2828}, {3106, 3164}, {7805, 7923}, {10724, 10815}}},
//     {"SIRV311", {{4601, 4762}}},
//     {"SIRV310", {{8759, 8966}, {9189, 9324}, {9667, 9914}}},
//     {"SIRV615", {{10237, 10818}, {11031, 11108}, {11205, 11330}}},
//     {"SIRV705", {{1005, 2675}, {2993, 3111}, {43028, 43077}, {114680, 114988}, {147608, 147925}}},
//     {"SIRV701", {{1003, 2675}, {2993, 3111}, {43028, 43077}, {114680, 114988}, {147608, 147923}}},
//     {"SIRV613", {{3105, 3164}, {7104, 7448}, {7805, 7923}, {10724, 10818}, {11031, 11108}, {11205, 11824}}},
//     {"SIRV610", {{2472, 2620}, {2740, 2828}, {3106, 3164}, {10724, 11108}, {11205, 11690}}},
//     {"SIRV611", {{1303, 1381}, {1468, 1534}, {1640, 1950}}},
//     {"SIRV403", {{8322, 8372}, {8629, 8990}, {13672, 13828}, {15019, 15122}}},
//     {"SIRV508", {{8315, 8382}, {8453, 8585}, {10859, 10991}, {11311, 11866}}},
//     {"SIRV501", {{1056, 1149}, {1987, 2033}, {2119, 2315}, {3298, 3404}, {3483, 3643}, {5380, 5450}, {5543, 5626}, {6111, 6169}, {6327, 6452}, {6658, 6722}, {6826, 6957}, {7144, 7307}, {7681, 7762}, {7870, 8016}, {8277, 8381}, {8454, 8585}, {10858, 10991}}},
//     {"SIRV406", {{3637, 4103}, {5007, 5158}}},
//     {"SIRV405", {{8629, 8990}, {13672, 13937}}},
//     {"SIRV404", {{8322, 8372}, {8629, 8990}, {13672, 13822}, {14592, 14623}}},
//     {"SIRV502", {{1019, 1149}, {1987, 2033}, {2119, 2156}, {2270, 2488}, {3298, 3404}, {3483, 3643}, {5380, 5450}, {5543, 5626}, {6111, 6169}, {6327, 6452}, {6658, 6722}, {6826, 6957}, {7144, 7307}, {7681, 7762}, {7870, 8016}, {8277, 8381}, {8454, 8585}, {10858, 10989}}},
//     {"SIRV503", {{8201, 8585}, {10858, 10991}, {11133, 11142}}},
//     {"SIRV409", {{1000, 1346}, {1678, 1885}, {2389, 3403}}},
//     {"SIRV408", {{8323, 8372}, {8629, 8747}, {8846, 8990}, {13672, 13828}, {15019, 15122}}},
//     {"SIRV506", {{1008, 1149}, {1987, 2398}}},
//     {"SIRV507", {{1027, 1149}, {1925, 2033}, {2119, 2156}, {2270, 2315}, {3298, 3404}, {3483, 3598}}},
//     {"SIRV504", {{11133, 13606}}},
//     {"SIRV505", {{1000, 1149}, {1987, 2033}, {2119, 2156}, {2270, 2315}, {3298, 3404}, {3483, 3643}, {5380, 5450}, {5543, 5626}, {6111, 6169}, {6327, 6452}, {6826, 6957}, {7144, 7307}, {7681, 7762}, {7870, 8381}, {8454, 8585}, {10858, 10991}}},
//     {"SIRV205", {{1108, 1631}}},
//     {"SIRV204", {{3643, 3825}, {3966, 4479}, {4687, 4732}}},
//     {"SIRV617", {{1544, 1820}}},
//     {"SIRV206", {{4033, 4457}}},
//     {"SIRV308", {{1000, 1167}, {1532, 1764}, {1902, 1982}}},
//     {"SIRV309", {{8797, 8975}, {9189, 9298}, {9434, 9943}}},
//     {"SIRV203", {{3665, 3825}, {3966, 4094}, {4338, 4479}, {4687, 4800}, {5751, 5895}}},
//     {"SIRV202", {{1035, 1661}, {1741, 1853}, {1973, 2064}, {2674, 2802}, {2881, 3010}, {3105, 3325}, {3665, 3825}, {3966, 4094}, {4338, 4479}, {4687, 4800}, {5788, 5911}}},
//     {"SIRV304", {{1963, 2005}, {4003, 4080}, {4568, 4779}, {6057, 6333}, {7270, 7366}, {7872, 7988}, {8124, 8207}, {8755, 8937}}},
//     {"SIRV305", {{4003, 4080}, {4568, 4779}, {6570, 6718}}},
//     {"SIRV306", {{1944, 2005}, {4003, 4080}, {6057, 8292}}},
//     {"SIRV307", {{1963, 2005}, {4003, 4080}, {4574, 4774}, {6057, 6333}, {8755, 8939}}},
//     {"SIRV612", {{1087, 1186}, {1468, 1534}, {1640, 1735}, {1845, 2026}, {2470, 2620}, {2740, 2828}, {3106, 3164}, {10724, 10818}, {11031, 11108}, {11205, 11825}}},
//     {"SIRV301", {{1944, 2005}, {4568, 4779}, {6057, 7988}, {8127, 8207}, {8755, 8939}}},
//     {"SIRV302", {{1963, 2005}, {6057, 7822}}},
//     {"SIRV303", {{1963, 2005}, {4568, 4779}, {6057, 7822}}},
//     {"SIRV708", {{56037, 56097}, {70883, 70987}, {78841, 78908}, {78928, 78963}, {114686, 114960}, {147608, 147957}}},
//     {"SIRV108", {{10582, 10791}, {10897, 11187}, {11403, 11606}}},
//     {"SIRV109", {{10711, 10791}, {10882, 11057}, {11434, 11643}}},
//     {"SIRV106", {{1000, 1484}, {7552, 7808}, {10553, 10786}}},
//     {"SIRV107", {{10647, 10791}, {10882, 11242}, {11403, 11643}}},
//     {"SIRV105", {{6449, 6473}, {6560, 6813}, {7552, 7814}, {10282, 10366}, {10593, 10640}}},
//     {"SIRV102", {{1006, 1484}, {6337, 6813}, {7552, 7814}, {10282, 10366}}},
//     {"SIRV103", {{1000, 1484}, {6337, 6473}, {6560, 6813}, {7552, 7814}, {10282, 10366}, {10647, 10791}}},
//     {"SIRV101", {{1000, 1484}, {6337, 6473}, {6560, 6813}, {7552, 7814}, {10282, 10366}, {10444, 10786}}},
//     {"SIRV602", {{1124, 1186}, {1468, 1534}, {1640, 1735}, {2780, 2828}, {3106, 3164}, {10724, 10818}, {11031, 11108}, {11205, 11279}}},
//     {"SIRV201", {{1000, 1661}, {1741, 1853}, {1973, 2064}, {2674, 2802}, {2881, 3010}, {3105, 3374}, {3665, 3825}, {3966, 4094}, {4338, 4479}, {4687, 4800}, {5788, 5907}}}
// };

// // transcript_to_exon = {
// // 	"SIRV410": [[1455, 1885], [2251, 2771]],
// // 	"SIRV706": [[56031, 56097], [70883, 70987], [78841, 78963], [114680, 114988], [147608, 147957]],
// // 	"SIRV618": [[2358, 2547]],
// // 	"SIRV511": [[1008, 1143], [1987, 2398]],
// // 	"SIRV510": [[1028, 1149], [1987, 2033], [2119, 2156], [2270, 2315], [3298, 3404], [3483, 3643], [5380, 5450], [5543, 5626], [6111, 6169], [6327, 6452], [6826, 6957], [7144, 7307], [7681, 7762], [7870, 8016], [8277, 8381], [8454, 8585], [10858, 10991], [11133, 11867]],
// // 	"SIRV512": [[2177, 2406]],
// // 	"SIRV601": [[1000, 1186], [1468, 1534], [1640, 1735], [2470, 2620], [2740, 2828], [3106, 3164], [10724, 10818], [11031, 11108], [11205, 11826]],
// // 	"SIRV616": [[2285, 2620], [2740, 2814], [3106, 3164], [10724, 10788]],
// // 	"SIRV603": [[8999, 10968]],
// // 	"SIRV509": [[8315, 8381], [8454, 8585], [10858, 10991], [11311, 11866]],
// // 	"SIRV605": [[1130, 1186], [1468, 1534], [1640, 1735], [1845, 2026], [2470, 2620], [2740, 2828], [3106, 3164], [10724, 10818], [11031, 11331]],
// // 	"SIRV604": [[1087, 1186], [1468, 1534], [1640, 1735], [1845, 2026], [2470, 2620], [2740, 2828], [3106, 3164], [10724, 10818], [11034, 11108], [11205, 11837]],
// // 	"SIRV607": [[1130, 1186], [1468, 1735], [1845, 2026], [2470, 2540]],
// // 	"SIRV606": [[2285, 2620], [2740, 2828], [3106, 3164], [10724, 10788]],
// // 	"SIRV609": [[1137, 1186], [1468, 1534], [1640, 1735], [1845, 2120]],
// // 	"SIRV608": [[3023, 3164], [10724, 10818], [11031, 11108], [11205, 11270]],
// // 	"SIRV702": [[1000, 2675], [2993, 3111], [4095, 4179], [4725, 4810], [43028, 43077], [114680, 114916]],
// // 	"SIRV703": [[1000, 2675], [2993, 3111], [3809, 3896], [114680, 114988], [147608, 147918]],
// // 	"SIRV704": [[55849, 56097], [78841, 78963], [114680, 114738]],
// // 	"SIRV614": [[2516, 2620], [2740, 2828], [3106, 3164], [7805, 7923], [10724, 10815]],
// // 	"SIRV311": [[4601, 4762]],
// // 	"SIRV310": [[8759, 8966], [9189, 9324], [9667, 9914]],
// // 	"SIRV615": [[10237, 10818], [11031, 11108], [11205, 11330]],
// // 	"SIRV705": [[1005, 2675], [2993, 3111], [43028, 43077], [114680, 114988], [147608, 147925]],
// // 	"SIRV701": [[1003, 2675], [2993, 3111], [43028, 43077], [114680, 114988], [147608, 147923]],
// // 	"SIRV613": [[3105, 3164], [7104, 7448], [7805, 7923], [10724, 10818], [11031, 11108], [11205, 11824]],
// // 	"SIRV610": [[2472, 2620], [2740, 2828], [3106, 3164], [10724, 11108], [11205, 11690]],
// // 	"SIRV611": [[1303, 1381], [1468, 1534], [1640, 1950]],
// // 	"SIRV403": [[8322, 8372], [8629, 8990], [13672, 13828], [15019, 15122]],
// // 	"SIRV508": [[8315, 8382], [8453, 8585], [10859, 10991], [11311, 11866]],
// // 	"SIRV501": [[1056, 1149], [1987, 2033], [2119, 2315], [3298, 3404], [3483, 3643], [5380, 5450], [5543, 5626], [6111, 6169], [6327, 6452], [6658, 6722], [6826, 6957], [7144, 7307], [7681, 7762], [7870, 8016], [8277, 8381], [8454, 8585], [10858, 10991]],
// // 	"SIRV406": [[3637, 4103], [5007, 5158]],
// // 	"SIRV405": [[8629, 8990], [13672, 13937]],
// // 	"SIRV404": [[8322, 8372], [8629, 8990], [13672, 13822], [14592, 14623]],
// // 	"SIRV502": [[1019, 1149], [1987, 2033], [2119, 2156], [2270, 2488], [3298, 3404], [3483, 3643], [5380, 5450], [5543, 5626], [6111, 6169], [6327, 6452], [6658, 6722], [6826, 6957], [7144, 7307], [7681, 7762], [7870, 8016], [8277, 8381], [8454, 8585], [10858, 10989]],
// // 	"SIRV503": [[8201, 8585], [10858, 10991], [11133, 11142]],
// // 	"SIRV409": [[1000, 1346], [1678, 1885], [2389, 3403]],
// // 	"SIRV408": [[8323, 8372], [8629, 8747], [8846, 8990], [13672, 13828], [15019, 15122]],
// // 	"SIRV506": [[1008, 1149], [1987, 2398]],
// // 	"SIRV507": [[1027, 1149], [1925, 2033], [2119, 2156], [2270, 2315], [3298, 3404], [3483, 3598]],
// // 	"SIRV504": [[11133, 13606]],
// // 	"SIRV505": [[1000, 1149], [1987, 2033], [2119, 2156], [2270, 2315], [3298, 3404], [3483, 3643], [5380, 5450], [5543, 5626], [6111, 6169], [6327, 6452], [6826, 6957], [7144, 7307], [7681, 7762], [7870, 8381], [8454, 8585], [10858, 10991]],
// // 	"SIRV205": [[1108, 1631]],
// // 	"SIRV204": [[3643, 3825], [3966, 4479], [4687, 4732]],
// // 	"SIRV617": [[1544, 1820]],
// // 	"SIRV206": [[4033, 4457]],
// // 	"SIRV308": [[1000, 1167], [1532, 1764], [1902, 1982]],
// // 	"SIRV309": [[8797, 8975], [9189, 9298], [9434, 9943]],
// // 	"SIRV203": [[3665, 3825], [3966, 4094], [4338, 4479], [4687, 4800], [5751, 5895]],
// // 	"SIRV202": [[1035, 1661], [1741, 1853], [1973, 2064], [2674, 2802], [2881, 3010], [3105, 3325], [3665, 3825], [3966, 4094], [4338, 4479], [4687, 4800], [5788, 5911]],
// // 	"SIRV304": [[1963, 2005], [4003, 4080], [4568, 4779], [6057, 6333], [7270, 7366], [7872, 7988], [8124, 8207], [8755, 8937]],
// // 	"SIRV305": [[4003, 4080], [4568, 4779], [6570, 6718]],
// // 	"SIRV306": [[1944, 2005], [4003, 4080], [6057, 8292]],
// // 	"SIRV307": [[1963, 2005], [4003, 4080], [4574, 4774], [6057, 6333], [8755, 8939]],
// // 	"SIRV612": [[1087, 1186], [1468, 1534], [1640, 1735], [1845, 2026], [2470, 2620], [2740, 2828], [3106, 3164], [10724, 10818], [11031, 11108], [11205, 11825]],
// // 	"SIRV301": [[1944, 2005], [4568, 4779], [6057, 7988], [8127, 8207], [8755, 8939]],
// // 	"SIRV302": [[1963, 2005], [6057, 7822]],
// // 	"SIRV303": [[1963, 2005], [4568, 4779], [6057, 7822]],
// // 	"SIRV708": [[56037, 56097], [70883, 70987], [78841, 78908], [78928, 78963], [114686, 114960], [147608, 147957]],
// // 	"SIRV108": [[10582, 10791], [10897, 11187], [11403, 11606]],
// // 	"SIRV109": [[10711, 10791], [10882, 11057], [11434, 11643]],
// // 	"SIRV106": [[1000, 1484], [7552, 7808], [10553, 10786]],
// // 	"SIRV107": [[10647, 10791], [10882, 11242], [11403, 11643]],
// // 	"SIRV105": [[6449, 6473], [6560, 6813], [7552, 7814], [10282, 10366], [10593, 10640]],
// // 	"SIRV102": [[1006, 1484], [6337, 6813], [7552, 7814], [10282, 10366]],
// // 	"SIRV103": [[1000, 1484], [6337, 6473], [6560, 6813], [7552, 7814], [10282, 10366], [10647, 10791]],
// // 	"SIRV101": [[1000, 1484], [6337, 6473], [6560, 6813], [7552, 7814], [10282, 10366], [10444, 10786]],
// // 	"SIRV602": [[1124, 1186], [1468, 1534], [1640, 1735], [2780, 2828], [3106, 3164], [10724, 10818], [11031, 11108], [11205, 11279]],
// // 	"SIRV201": [[1000, 1661], [1741, 1853], [1973, 2064], [2674, 2802], [2881, 3010], [3105, 3374], [3665, 3825], [3966, 4094], [4338, 4479], [4687, 4800], [5788, 5907]]
// // }

// static std::unordered_map<std::string, std::vector<std::string>>
// chr_to_gene = {{"SIRV1", {"SIRV1"}}, {"SIRV2", {"SIRV2"}}, {"SIRV3", {"SIRV3"}}, {"SIRV4", {"SIRV4"}}, {"SIRV5", {"SIRV5"}}, {"SIRV6", {"SIRV6"}},{"SIRV7", {"SIRV7"}}};

// static std::unordered_map<std::string, std::vector<exon>>
// gene_dict = {
//     {"SIRV1", {{1000, 1484}, {6337, 6813}, {7552, 7814}, {10282, 10366}, {10444, 10791}, {10882, 11242}, {11403, 11643}}},
//     {"SIRV2", {{1000, 1661}, {1741, 1853}, {1973, 2064}, {2674, 2802}, {2881, 3010}, {3105, 3374}, {3643, 3825}, {3966, 4479}, {4687, 4800}, {5751, 5911}}},
//     {"SIRV3", {{1000, 1167}, {1532, 1764}, {1902, 2005}, {4003, 4080}, {4568, 4779}, {6057, 8292}, {8755, 8975}, {9189, 9324}, {9434, 9943}}},
//     {"SIRV4", {{1000, 1346}, {1455, 1885}, {2251, 3403}, {3637, 4103}, {5007, 5158}, {8322, 8372}, {8629, 8990}, {13672, 13937}, {14592, 14623}, {15019, 15122}}},
//     {"SIRV5", {{1000, 1149}, {1925, 2488}, {3298, 3404}, {3483, 3643}, {5380, 5450}, {5543, 5626}, {6111, 6169}, {6327, 6452}, {6658, 6722}, {6826, 6957}, {7144, 7307}, {7681, 7762}, {7870, 8585}, {10858, 10991}, {11133, 13606}}},
//     {"SIRV6", {{1000, 1186}, {1303, 1381}, {1468, 2120}, {2285, 2620}, {2740, 2828}, {3023, 3164}, {7104, 7448}, {7805, 7923}, {8999, 11837}}},
//     {"SIRV7", {{1000, 2675}, {2993, 3111}, {3809, 3896}, {4095, 4179}, {4725, 4810}, {43028, 43077}, {55849, 56097}, {70883, 70987}, {78841, 78963}, {114680, 114988}, {147608, 147957}}}
// };

// static std::unordered_map<std::string, Junctions> 
// transcript_to_junctions = {
// 	{"SIRV410", {1455, {1885, 2251}, 2771}},
// 	{"SIRV203", {3665, {3825, 3966, 4094, 4338, 4479, 4687, 4800, 5751}, 5895}},
// 	{"SIRV408", {8323, {8372, 8629, 8747, 8846, 8990, 13672, 13828, 15019}, 15122}},
// 	{"SIRV511", {1008, {1143, 1987}, 2398}},
// 	{"SIRV510", {1028, {1149, 1987, 2033, 2119, 2156, 2270, 2315, 3298, 3404, 3483, 3643, 5380, 5450, 5543, 5626, 6111, 6169, 6327, 6452, 6826, 6957, 7144, 7307, 7681, 7762, 7870, 8016, 8277, 8381, 8454, 8585, 10858, 10991, 11133}, 11867}},
// 	{"SIRV512", {2177, {}, 2406}},
// 	{"SIRV601", {1000, {1186, 1468, 1534, 1640, 1735, 2470, 2620, 2740, 2828, 3106, 3164, 10724, 10818, 11031, 11108, 11205}, 11826}},
// 	{"SIRV304", {1963, {2005, 4003, 4080, 4568, 4779, 6057, 6333, 7270, 7366, 7872, 7988, 8124, 8207, 8755}, 8937}},
// 	{"SIRV603", {8999, {}, 10968}},
// 	{"SIRV602", {1124, {1186, 1468, 1534, 1640, 1735, 2780, 2828, 3106, 3164, 10724, 10818, 11031, 11108, 11205}, 11279}},
// 	{"SIRV605", {1130, {1186, 1468, 1534, 1640, 1735, 1845, 2026, 2470, 2620, 2740, 2828, 3106, 3164, 10724, 10818, 11031}, 11331}},
// 	{"SIRV604", {1087, {1186, 1468, 1534, 1640, 1735, 1845, 2026, 2470, 2620, 2740, 2828, 3106, 3164, 10724, 10818, 11034, 11108, 11205}, 11837}},
// 	{"SIRV607", {1130, {1186, 1468, 1735, 1845, 2026, 2470}, 2540}},
// 	{"SIRV606", {2285, {2620, 2740, 2828, 3106, 3164, 10724}, 10788}},
// 	{"SIRV609", {1137, {1186, 1468, 1534, 1640, 1735, 1845}, 2120}},
// 	{"SIRV608", {3023, {3164, 10724, 10818, 11031, 11108, 11205}, 11270}},
// 	{"SIRV702", {1000, {2675, 2993, 3111, 4095, 4179, 4725, 4810, 43028, 43077, 114680}, 114916}},
// 	{"SIRV703", {1000, {2675, 2993, 3111, 3809, 3896, 114680, 114988, 147608}, 147918}},
// 	{"SIRV704", {55849, {56097, 78841, 78963, 114680}, 114738}},
// 	{"SIRV705", {1005, {2675, 2993, 3111, 43028, 43077, 114680, 114988, 147608}, 147925}},
// 	{"SIRV311", {4601, {}, 4762}},
// 	{"SIRV310", {8759, {8966, 9189, 9324, 9667}, 9914}},
// 	{"SIRV307", {1963, {2005, 4003, 4080, 4574, 4774, 6057, 6333, 8755}, 8939}},
// 	{"SIRV612", {1087, {1186, 1468, 1534, 1640, 1735, 1845, 2026, 2470, 2620, 2740, 2828, 3106, 3164, 10724, 10818, 11031, 11108, 11205}, 11825}},
// 	{"SIRV701", {1003, {2675, 2993, 3111, 43028, 43077, 114680, 114988, 147608}, 147923}},
// 	{"SIRV301", {1944, {2005, 4568, 4779, 6057, 7988, 8127, 8207, 8755}, 8939}},
// 	{"SIRV706", {56031, {56097, 70883, 70987, 78841, 78963, 114680, 114988, 147608}, 147957}},
// 	{"SIRV303", {1963, {2005, 4568, 4779, 6057}, 7822}},
// 	{"SIRV305", {4003, {4080, 4568, 4779, 6570}, 6718}},
// 	{"SIRV403", {8322, {8372, 8629, 8990, 13672, 13828, 15019}, 15122}},
// 	{"SIRV508", {1008, {1149, 1987, 2033, 2119, 2156, 2270, 2315, 3298, 3404, 3483, 3643, 5380, 5450, 5543, 5626, 6111, 6169, 6327, 6452, 6658, 6722, 6826, 6957, 7144, 7307, 7681, 7762, 7870, 8381, 8454, 8585, 10858}, 10991}},
// 	{"SIRV509", {8315, {8381, 8454, 8585, 10858, 10991, 11311}, 11866}},
// 	{"SIRV406", {3637, {4103, 5007}, 5158}},
// 	{"SIRV405", {8629, {8990, 13672}, 13937}},
// 	{"SIRV404", {8322, {8372, 8629, 8990, 13672, 13822, 14592}, 14623}},
// 	{"SIRV502", {1019, {1149, 1987, 2033, 2119, 2156, 2270, 2488, 3298, 3404, 3483, 3643, 5380, 5450, 5543, 5626, 6111, 6169, 6327, 6452, 6658, 6722, 6826, 6957, 7144, 7307, 7681, 7762, 7870, 8016, 8277, 8381, 8454, 8585, 10858}, 10989}},
// 	{"SIRV503", {8201, {8585, 10858, 10991, 11133}, 11142}},
// 	{"SIRV409", {1000, {1346, 1678, 1885, 2389}, 3403}},
// 	{"SIRV501", {1056, {1149, 1987, 2033, 2119, 2315, 3298, 3404, 3483, 3643, 5380, 5450, 5543, 5626, 6111, 6169, 6327, 6452, 6658, 6722, 6826, 6957, 7144, 7307, 7681, 7762, 7870, 8016, 8277, 8381, 8454, 8585, 10858}, 10991}},
// 	{"SIRV506", {1008, {1149, 1987}, 2398}},
// 	{"SIRV507", {1027, {1149, 1925, 2033, 2119, 2156, 2270, 2315, 3298, 3404, 3483}, 3598}},
// 	{"SIRV504", {11133, {}, 13606}},
// 	{"SIRV505", {1000, {1149, 1987, 2033, 2119, 2156, 2270, 2315, 3298, 3404, 3483, 3643, 5380, 5450, 5543, 5626, 6111, 6169, 6327, 6452, 6826, 6957, 7144, 7307, 7681, 7762, 7870, 8381, 8454, 8585, 10858}, 10991}},
// 	{"SIRV205", {1108, {}, 1631}},
// 	{"SIRV204", {3643, {3825, 3966, 4479, 4687}, 4732}},
// 	{"SIRV206", {4033, {}, 4457}},
// 	{"SIRV308", {1000, {1167, 1532, 1764, 1902}, 1982}},
// 	{"SIRV309", {8797, {8975, 9189, 9298, 9434}, 9943}},
// 	{"SIRV618", {2358, {}, 2547}},
// 	{"SIRV202", {1035, {1661, 1741, 1853, 1973, 2064, 2674, 2802, 2881, 3010, 3105, 3325, 3665, 3825, 3966, 4094, 4338, 4479, 4687, 4800, 5788}, 5911}},
// 	{"SIRV616", {2285, {2620, 2740, 2814, 3106, 3164, 10724}, 10788}},
// 	{"SIRV617", {1544, {}, 1820}},
// 	{"SIRV614", {2516, {2620, 2740, 2828, 3106, 3164, 7805, 7923, 10724}, 10815}},
// 	{"SIRV615", {10237, {10818, 11031, 11108, 11205}, 11330}},
// 	{"SIRV306", {1944, {2005, 4003, 4080, 6057}, 8292}},
// 	{"SIRV613", {3105, {3164, 7104, 7448, 7805, 7923, 10724, 10818, 11031, 11108, 11205}, 11824}},
// 	{"SIRV610", {2472, {2620, 2740, 2828, 3106, 3164, 10724, 11108, 11205}, 11690}},
// 	{"SIRV611", {1303, {1381, 1468, 1534, 1640}, 1950}},
// 	{"SIRV708", {56037, {56097, 70883, 70987, 78841, 78908, 78928, 78963, 114686, 114960, 147608}, 147957}},
// 	{"SIRV108", {10582, {10791, 10897, 11187, 11403}, 11606}},
// 	{"SIRV302", {1963, {2005, 6057}, 7822}},
// 	{"SIRV109", {10711, {10791, 10882, 11057, 11434}, 11643}},
// 	{"SIRV106", {1000, {1484, 7552, 7808, 10553}, 10786}},
// 	{"SIRV107", {10647, {10791, 10882, 11242, 11403}, 11643}},
// 	{"SIRV105", {6449, {6473, 6560, 6813, 7552, 7814, 10282, 10366, 10593}, 10640}},
// 	{"SIRV102", {1006, {1484, 6337, 6813, 7552, 7814, 10282}, 10366}},
// 	{"SIRV103", {1000, {1484, 6337, 6473, 6560, 6813, 7552, 7814, 10282, 10366, 10647}, 10791}},
// 	{"SIRV101", {1000, {1484, 6337, 6473, 6560, 6813, 7552, 7814, 10282, 10366, 10444}, 10786}},
// 	{"SIRV201", {1000, {1661, 1741, 1853, 1973, 2064, 2674, 2802, 2881, 3010, 3105, 3374, 3665, 3825, 3966, 4094, 4338, 4479, 4687, 4800, 5788}, 5907}}
// };


// context("Junctions Functions") {
//     // is_exon_similar
//     test_that("exons compare correctly") {
// 		std::vector<exon> exon1 {
// 			{1008, 1149}, {1987, 2033}, {2119, 2156}, {2270, 2315}, {3298, 3404}, {3483, 3643}, {5380, 5450}, {5543, 5626}, {6111, 6169}, {6327, 6452}, {6658, 6722}, {6826, 6957}, {7144, 7307}, {7681, 7762}, {7870, 8381}, {8454, 8585}, {10858, 10991}
// 		};
// 		std::vector<exon>  exon2 {
// 			{8315, 8381}, {8454, 8585}, {10858, 10991}, {11311, 11866}
// 		};
// 		expect_true(!is_exon_similar(exon1, exon2, 10));

// 		std::vector<exon>  exon3 {
// 			{1008, 1149}, {1987, 2398}
// 		};
// 		std::vector<exon>  exon4 {
// 			{1008, 1143}, {1987, 2398}
// 		};
// 		expect_true(is_exon_similar(exon3, exon4, 10));
// 	}
//     // remove_similar_tr
// 	test_that("similar transcripts are correctly removed") {
//         auto unique_tr = remove_similar_tr(gene_to_transcript, transcript_to_exon, 10);

// 		std::unordered_map<std::string, transcriptvector> res_gene {
//             {"SIRV5",  {"SIRV508", "SIRV502", "SIRV503", "SIRV501", "SIRV506", "SIRV507", "SIRV504", "SIRV505", "SIRV512", "SIRV510"}}, 
//             {"SIRV4",  {"SIRV403", "SIRV410", "SIRV406", "SIRV405", "SIRV404", "SIRV409", "SIRV408"}}, 
//             {"SIRV7",  {"SIRV708", "SIRV701", "SIRV702", "SIRV703", "SIRV704", "SIRV706"}}, 
//             {"SIRV6",  {"SIRV618", "SIRV617", "SIRV601", "SIRV616", "SIRV603", "SIRV602", "SIRV605", "SIRV604", "SIRV607", "SIRV606", "SIRV609", "SIRV608", "SIRV614", "SIRV615", "SIRV612", "SIRV613", "SIRV610", "SIRV611"}}, 
//             {"SIRV1",  {"SIRV108", "SIRV109", "SIRV106", "SIRV107", "SIRV105", "SIRV102", "SIRV103", "SIRV101"}}, 
//             {"SIRV3",  {"SIRV310", "SIRV311", "SIRV308", "SIRV309", "SIRV304", "SIRV305", "SIRV306", "SIRV307", "SIRV301", "SIRV302", "SIRV303"}}, 
//             {"SIRV2",  {"SIRV205", "SIRV204", "SIRV206", "SIRV201", "SIRV203", "SIRV202"}}
//         };

// 		expect_true(compare_map(res_gene, unique_tr));
// 	}
//     // get_gene_flat
//     test_that("genes can be flattened correctly") {
//         std::unordered_map<std::string, transcriptvector> gsmall {
//             {"SIRV5", gene_to_transcript["SIRV5"]}
//         };

//         auto flat = get_gene_flat(gsmall, transcript_to_exon);

//         std::unordered_map<std::string, std::vector<exon>> real {
//             {"SIRV5", {{1000, 1149}, {1925, 2488}, {3298, 3404}, {3483, 3643}, {5380, 5450}, {5543, 5626}, {6111, 6169}, {6327, 6452}, {6658, 6722}, {6826, 6957}, {7144, 7307}, {7681, 7762}, {7870, 8585}, {10858, 10991}, {11133, 13606}}}
//         };
        
//         expect_true(compare_map(real, flat));
//     }
//     // get_gene_blocks
//     test_that("genes blocks can be correctly calculated") {
//         std::unordered_map<std::string, std::vector<GeneBlocks>>
//         chr = get_gene_blocks(gene_dict, chr_to_gene, gene_to_transcript);

//         std::unordered_map<std::string, std::vector<int>> chr_to_blocks = {
//             {"SIRV1", {1000, 11643, 8, 1}},
//             {"SIRV2", {1000, 5911, 6, 1}},
//             {"SIRV3", {1000, 9943, 11, 1}},
//             {"SIRV4", {1000, 15122, 7, 1}},
//             {"SIRV5", {1000, 13606, 11, 1}},
//             {"SIRV6", {1000, 11837, 18, 1}},
//             {"SIRV7", {1000, 147957, 6, 1}}
//         };

//         expect_true(chr.size() == chr_to_blocks.size());
        
//         for (const auto &[ch, blocks] : chr) {
//             expect_true(chr_to_blocks[ch][0] == blocks[0].start);
//             expect_true(chr_to_blocks[ch][1] == blocks[0].end);
//             expect_true(chr_to_blocks[ch][2] == blocks[0].transcript_list.size());
//             expect_true(chr_to_blocks[ch][3] == blocks[0].gene_to_transcript.size());
//         }
//     }
//     // get_TSS_TES_site
// 	test_that("TSS_TES Sites can be acquired") {
// 		// // python :
// 		// // from sc_longread import blocks_to_junctions, get_TSS_TES_site
// 		// // from parse_gene_anno import parse_gff_tree
// 		// // gff3 = "/Volumes/voogd.o/FLAMES/inst/extdata/SIRV_anno.gtf"
// 		// // chr, tran, gene, exon = parse_gff_tree(gff3)
// 		// // transcript_to_junctions = {tr : blocks_to_junctions(exon[tr]) for tr in exon}
// 		// // remove_similar_tr(tran, gene, exon)
// 		// // gene_dict = get_gene_flat(gene, exon)
// 		// // chr_to_blocks = get_gene_blocks(gene_dict, chr, gene)
// 		// // ch = chr_to_blocks.keys()[0]
// 		// // bl = chr_to_blocks[ch][0]
// 		// // TSS_TES_site = get_TSS_TES_site(transcript_to_junctions, bl.transcript_list)
		
		
// 		const std::vector<std::string> tr_list {
// 			"SIRV508", "SIRV509", "SIRV502", "SIRV503", "SIRV501", "SIRV506", "SIRV507", "SIRV504", "SIRV505", "SIRV512", "SIRV510", "SIRV511"
// 		};

// 		DoubleJunctions sites = get_TSS_TES_site(transcript_to_junctions, tr_list);

// 		DoubleJunctions real_sites {
// 			{1000, 1008, 1019, 1027, 1056, 2177, 8201, 8315, 11133},
// 			{2398, 2406, 3598, 10991, 11142, 11866, 13606}
// 		};

// 		expect_true(compare_unordered(sites.left, real_sites.left));
// 		expect_true(compare_unordered(sites.right, real_sites.right));

// 		const std::vector<std::string> tr_list2 {
// 			"SIRV310", "SIRV311", "SIRV308", "SIRV309", "SIRV304", "SIRV305", "SIRV306", "SIRV307", "SIRV301", "SIRV302", "SIRV303"
// 		};
// 		DoubleJunctions sites2 = get_TSS_TES_site(transcript_to_junctions, tr_list2);
// 		DoubleJunctions real_sites2 {
// 			{1000, 1944, 1963, 4003, 4601, 8759, 8797},
// 			{1982, 4762, 6718, 7822, 8292, 8937, 9914, 9943}
// 		};
// 		expect_true(compare_unordered(sites2.left, real_sites2.left));
// 		expect_true(compare_unordered(sites2.right, real_sites2.right));
// 	}
//     // take_closest
//     test_that("take_closest takes the closest") {
// 		std::vector<int> sample {1,2,3,4,5,8,10,20,30,60,100};
		
// 		expect_true(take_closest(sample, 6) == 5);
// 		expect_true(take_closest(sample, 80) == 60);
// 		expect_true(take_closest(sample, 14) == 10);
// 	}
//     // get_splice_site
//     test_that("splice sites can be aquired") {
// 		std::vector<std::string> tr_list {
// 			"SIRV508", "SIRV509", "SIRV502", "SIRV503", "SIRV501", "SIRV506", "SIRV507", "SIRV504", "SIRV505", "SIRV512", "SIRV510"
// 		};

// 		std::set<int> out_site = get_splice_site(transcript_to_junctions, tr_list);

// 		std::set<int> real_site {
// 			1149, 1925, 1987, 2033, 2119, 2156, 2270, 2315, 2488, 3298, 3404, 3483, 3643, 5380, 5450, 5543, 5626, 6111, 6169, 6327, 6452, 6658, 6722, 6826, 6957, 7144, 7307, 7681, 7762, 7870, 8016, 8277, 8381, 8454, 8585, 10858, 10991, 11133, 11311
// 		};

// 		expect_true(compare_stream(real_site, out_site));
// 	}
//     // find_best_splice_chain

//     // blocks_to_junctions

//     // map_transcripts_to_junctions

//     // exon_overlap

//     // checkExonSubset

//     // get_exon_sim_pct
// }
