% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/AllMethods.R
\docType{class}
\name{FELLA.USER-class}
\alias{FELLA.USER-class}
\alias{FELLA.USER}
\alias{show,FELLA.USER-method}
\alias{plot,FELLA.USER,missing-method}
\title{An S4 class to save all the user analysis data}
\usage{
\S4method{show}{FELLA.USER}(object)

\S4method{plot}{FELLA.USER,missing}(x = new("FELLA.USER"),
    method = "hypergeom", threshold = 0.05, plimit = 15,
    nlimit = 250, layout = FALSE, thresholdConnectedComponent = 0.05,
    LabelLengthAtPlot = 22, data = NULL, ...)
}
\arguments{
\item{object}{A \code{\link{FELLA.USER}} object}

\item{x}{A \code{\link{FELLA.USER}} object}

\item{method}{Character, exactly one of: 
\code{"hypergeom"}, \code{"diffusion"}, \code{"pagerank"}}

\item{threshold}{Numeric value between 0 and 1. 
\code{p.score} threshold applied when filtering KEGG nodes. 
Lower thresholds are more stringent.}

\item{plimit}{Pathway limit, must be a numeric value between 1 and 50. 
Limits the amount of pathways in \code{method = "hypergeom"}}

\item{nlimit}{Node limit, must be a numeric value between 1 and 1000. 
Limits the order of the solution sub-graph when 
in \code{method = "diffusion"} and \code{method = "pagerank"}}

\item{layout}{Logical, should the plot be returned as a layout?}

\item{thresholdConnectedComponent}{Numeric value between 0 and 1. 
Connected components that are below the threshold are kept, 
while the ones exceeding it (because they are too small) are discarded.}

\item{LabelLengthAtPlot}{Numeric value between 10 and 50. 
Maximum length that a label can reach when plotting the graph. 
The remaining characters will be truncated using "..."}

\item{data}{FELLA.DATA object}

\item{...}{Additional arguments passed to plotting functions}
}
\value{
\code{show} invisibly returns a list of data frames with the 
best hits for each applied method

\code{plot} returns a layout if \code{layout = T}, 
otherwise \code{invisible()}
}
\description{
Assigning the value of show to a variable will provide
small data frames with the best scoring pathways (\code{hypergeom})
and the best nodes in the KEGG network (\code{diffusion} and 
\code{pagerank})
}
\section{Slots}{

\describe{
\item{\code{userinput}}{A \code{U.userinput} S4 object}

\item{\code{hypergeom}}{A \code{U.hypergeom} S4 object}

\item{\code{diffusion}}{A \code{U.diffusion} S4 object}

\item{\code{pagerank}}{A \code{U.pagerank} S4 object}
}}

