% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenerics.R,
%   R/SubsetRangedSummarizedExperiment.R, R/SubsetSingleCellExperiment.R,
%   R/SubsetSummarizedExperiment.R, R/SubsetSpatialExperiment.R,
%   R/SubsetTreeSummarizedExperiment.R
\name{createSubset}
\alias{createSubset}
\alias{createSubset,SubsetRangedSummarizedExperiment-method}
\alias{createSubset,SubsetSingleCellExperiment-method}
\alias{createSubset,SubsetSummarizedExperiment-method}
\alias{createSubset,SubsetSpatialExperiment-method}
\alias{createSubset,SubsetTreeSummarizedExperiment-method}
\title{Subset creation method for ExperimentSubset objects}
\usage{
createSubset(x, subsetName, rows = NULL, cols = NULL, parentAssay = NULL)

\S4method{createSubset}{SubsetRangedSummarizedExperiment}(x, subsetName, rows = NULL, cols = NULL, parentAssay = NULL)

\S4method{createSubset}{SubsetSingleCellExperiment}(x, subsetName, rows = NULL, cols = NULL, parentAssay = NULL)

\S4method{createSubset}{SubsetSummarizedExperiment}(x, subsetName, rows = NULL, cols = NULL, parentAssay = NULL)

\S4method{createSubset}{SubsetSpatialExperiment}(x, subsetName, rows = NULL, cols = NULL, parentAssay = NULL)

\S4method{createSubset}{SubsetTreeSummarizedExperiment}(x, subsetName, rows = NULL, cols = NULL, parentAssay = NULL)
}
\arguments{
\item{x}{\code{ExperimentSubset} Specify the object from which a subset
should be created. Input can also be any object inherited from
\code{SummarizedExperiment} for immediate conversion and subset formation.
A list of slots can also be passed to directly construct an ES object from
matrices similar to SE and SCE constructors.}

\item{subsetName}{\code{character(1)} Specify the name of the subset to
create.}

\item{rows}{\code{vector("numeric")} Specify the rows to include in this
subset. If \code{missing} or \code{NULL}, all rows are included in the
subset. Values can be \code{numeric} or \code{character}. Default
\code{NULL}.}

\item{cols}{\code{vector("numeric")} Specify the columns to include in this
subset. If \code{missing} or \code{NULL}, all columns are included in the
subset. Values can be \code{numeric} or \code{character}. Default
\code{NULL}.}

\item{parentAssay}{\code{character(1)} Specify the parent \code{assay} of the
subset. This parent \code{assay} must already be available in the
\code{ExperimentSubset} object. If \code{NULL}, the first available main
\code{assay} will be marked as parent. Default \code{NULL}.}
}
\value{
An \code{ExperimentSubset} object that now contains the newly created
  subset.
}
\description{
Create a subset from an already available \code{assay} in the
  input \code{ExperimentSubset} object by specifying the rows and columns to
  include in the subset.
}
\examples{
data(sce_chcl, package = "scds")
es <- ExperimentSubset(sce_chcl)
es <- createSubset(es,
"subset1",
rows = c(10,11,50,56,98,99,102,105,109, 200),
cols = c(20,21,40,45,90,99,100,123,166,299),
parentAssay = "counts")
es
}
