\name{ExperimentHubMetadata-class}
\docType{class}

% Class:
\alias{class:ExperimentHubMetadata}
\alias{ExperimentHubMetadata-class}
\alias{ExperimentHubMetadata}

% Constructors:
\alias{ExperimentHubMetadata}

% Show:
\alias{show,ExperimentHubMetadata-method}


\title{Class \link{ExperimentHubMetadata} objects and methods}

\description{
  The \link{ExperimentHubMetadata} object is used to represent records in the
  server data base.
}

\usage{
ExperimentHubMetadata(ExperimentHubRoot=NA_character_,
	BiocVersion=BiocManager::version(),
	SourceUrl=NA_character_,
	SourceType=NA_character_,
	SourceVersion=NA_character_,
	SourceLastModifiedDate=as.POSIXct(NA_character_),
	SourceMd5=NA_character_,
	SourceSize=NA_real_,
	DataProvider=NA_character_,
	Title=NA_character_,
	Description=NA_character_,
	Maintainer=NA_character_,
	Species=NA_character_,
	TaxonomyId=NA_integer_,
	Genome=NA_character_,
	Tags=NA_character_,
	RDataClass=NA_character_,
	RDataDateAdded=as.POSIXct(NA_character_),
	RDataPath=NA_character_,
	Coordinate_1_based=TRUE,
	Notes=NA_character_,
	DispatchClass=NA_character_,
	PreparerClass=NA_character_,
	Location_Prefix='https://bioconductorhubs.blob.core.windows.net/experimenthub/')
}

\details{

  In practice, instances of this class are generated by a call to
  \code{addResources} or \code{makeExperimentHubMetadata} instead of
  a direct call to the constructor.

  \code{addResources} is a function used by the Bioconductor Core team when
  adding new metadata records to the production database.
  \code{makeExperimentHubMetadata} and the low-level helper
}

\arguments{
    \item{ExperimentHubRoot}{
      \code{character(1)} Prefix of the local path to resources to be added
      to ExperimentHub. Internal use only.
    }
    \item{SourceUrl}{
      \code{character()} URL of original resource(s).
    }
    \item{SourceType}{
      \code{character()} Form of original data, e.g., BED, FASTA,
    etc. \code{getValidSourceTypes()} list currently acceptable
    values. If nothing seems appropiate for your data reach out to
    maintainer@bioconductor.org.

    }
    \item{SourceVersion}{
      \code{character(1)} Version of original file.
    }
    \item{SourceLastModifiedDate}{
      \code{POSIXct()} Date when resource was last modified.
    }
    \item{SourceMd5}{
      \code{character(1)} md5 hash of original file.
    }
    \item{SourceSize}{
      \code{numeric(1)} Number of bytes in original file.
    }
    \item{DataProvider}{
      \code{character(1)} Provider of original data, e.g., NCBI,
      UniProt etc.
    }
    \item{Title}{
      \code{character(1)} Title for the resource with version or genome
      build as appropriate. Titles must be unique and not match any existing
      title in ExperimentHub.
    }
    \item{Description}{
      \code{character(1)} Description of the resource. May include
      details such as data type, format, study origin, sequencing
      technology, treated vs control, number of samples etc.
    }
    \item{Species}{
      \code{character(1)} Species name.For help on valid
	species see \code{getSpeciesList, validSpecies, or suggestSpecies.}
    }
    \item{TaxonomyId}{
      \code{character(1)} NCBI code. Taxonomy ID. There are
	checks for valid taxonomyId given the Species which produce
	warnings. See GenomeInfoDb::loadTaxonomyDb() for full validation
	table.

    }
    \item{Genome}{
      \code{character(1)} Name of genome build.
    }
    \item{Tags}{
      \sQuote{Tags} are search terms used to define a subset of
      resources in a \code{Hub} object, e.g, in a call to \code{query}.

      For ExperimentHub resources, \sQuote{Tags} are automatically generated
      from the \sQuote{biocViews} in the DESCRIPTION file of the accompanying
      software package.  \sQuote{Tags} values supplied by the user are not be
      entered in the database and are not part of the formal metadata. This
      'controlled vocabulary' approach was taken to limit the search terms to a
      well defined set and may change in the future.
    }
    \item{RDataClass}{
      \code{character(1)} Class of derived object (e.g. \sQuote{GRanges}).
    }
    \item{RDataDateAdded}{
      \code{POSIXct()} Date resource was added to ExperimentHub. The default
      is today's date and is auto-generated when metadata are constructed.
      Resources will appear in snapshots with a date greater than
      or equal to the \code{RDataDateAdded}.
    }
    \item{RDataPath}{
      \code{character()} File path to where object is stored in AWS S3 bucket
      or on the web.The
	      \code{Location_Prefix} will be prepended to
	      \code{RDataPath} for the full path to the resource.
	      If the resource is stored in Bioconductor's AWS S3
	      buckets, it should start with the name of the package associated
	      with the metadata and should not start with a leading
	      slash. It should include the resource file name. For
	      strongly associated files, like a bam file and its index
	      file, the two files should be separates with a colon
	      \code{:}. This will link a single hub id with the multiple files.

    }
    \item{Maintainer}{
      \code{character(1)} Maintainer name and email address,
      \sQuote{A Maintainer \url{a.maintainer@email.addr}}
    }
    \item{BiocVersion}{
      \code{character(1)}. The first Bioconductor version the resource was made
      available for. Unless removed from the hub, the resource will be
      available for all versions greater than or equal to this field.
    }
    \item{Coordinate_1_based}{
      \code{logical(1)} Do coordinates start with 1 or 0?
    }
    \item{DispatchClass}{
      \code{character(1)}. Determines how data are loaded into R. The value for
      this field should be \sQuote{Rda} if the data were serialized with
      \code{save()} and \sQuote{Rds} if serialized with \code{saveRDS}. The
      filename should have the appropriate \sQuote{rda} or \sQuote{rds}
      extension.

      A number of dispatch classes are pre-defined in
      AnnotationHub/R/AnnotationHubResource-class.R with the suffix
      \sQuote{Resource}. For example, if you have sqlite files, the
      AnnotationHubResource-class.R defines SQLiteFileResource so the
      DispatchClass would be SQLiteFile. Contact maintainer@bioconductor.org if
      you are not sure which class to use.The function
	      \code{AnnotationHub::DispatchClassList()} will output a
	      matrix of currently implemented DispatchClass and brief
	      description of utility. If a predefine class does not seem
	      appropriate contact maintainer@bioconductor.org.

    }
    \item{Location_Prefix}{
      \code{character(1)} URL location of AWS S3 bucket or web site where
      resource is located.
    }
    \item{Notes}{
      \code{character()} Notes about the resource.
    }
    \item{PreparerClass}{
      \code{character(1)} Used internally.
    }
}

\value{
  A \link{ExperimentHubMetadata} object.
}

\seealso{
  \itemize{
    \item \link{addResources}
    \item \link[ExperimentHubData]{makeExperimentHubMetadata}
  }
}

\examples{
showClass("ExperimentHubMetadata")
}

\keyword{classes}
