% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPSI_RNASeq_boot.R
\name{getPSI_RNASeq_boot}
\alias{getPSI_RNASeq_boot}
\title{getPSI_RNASeq_boot}
\usage{
getPSI_RNASeq_boot(Result, lambda = NULL, cores = 1, nboot = 20)
}
\arguments{
\item{Result}{An EventPointer result object from RNA-Seq analysis (e.g., from EventsDetection_BAM).
Must contain count matrices that can be extracted with getCountMatrix.}

\item{lambda}{Regularization parameter for PSI estimation. Default is 0.1 if NULL.
Controls the smoothness of PSI estimates.}

\item{cores}{The number of cores to use for parallel computation. Default is 1.}

\item{nboot}{Number of bootstrap iterations to perform. Default is 20.
Higher values provide more stable estimates but increase computation time.}
}
\value{
A 3-dimensional array with dimensions (events, bootstrap samples + 1, samples).
  The first layer (bootstrap sample 1) contains the original PSI estimates,
  followed by nboot bootstrap replicates.
}
\description{
Calculates PSI (Percent Spliced In) values with bootstrap resampling for RNA-Seq data.
This function estimates PSI values using a median polish approach and generates bootstrap samples
to assess the variability of PSI estimates.
}
\details{
The function performs the following steps:
\enumerate{
  \item Extracts count matrices from the Result object
  \item Applies median polish to log-transformed count ratios to estimate normalization factors
  \item Performs parallel bootstrap resampling to generate multiple PSI estimates
  \item Combines original PSI with bootstrap samples into a single array
}

The bootstrap procedure uses parallel processing to distribute computations across multiple cores.
}
\examples{
\dontrun{
# Assuming 'eventsResult' is an EventPointer RNA-Seq result object
PSI_boot <- getPSI_RNASeq_boot(Result = eventsResult,
                               lambda = 0.1,
                               cores = 4,
                               nboot = 20)

# Access original PSI estimates
original_PSI <- PSI_boot[, 1, ]

# Access bootstrap samples
bootstrap_PSI <- PSI_boot[, 2:(nboot+1), ]
}

}
